MOEWE.Addons.ContentRating.View.NamesList = MOEWE.Addons.ContentRating.View.NamesList || new function () {
    this.dialogManager = new MOEWE.Addons.ContentRating.InlineDialogManager()

    this.namesLists = {}

    this.displayNamesList = (anchor, criterionId, criterionName, userItems, total) => {

        if (userItems === undefined) {
            userItems = [];
        }

        if (userItems.length === 0 && criterionName === "") {
            return;
        }


        if (this.namesLists[criterionId] !== undefined) {
            this.namesLists[criterionId].open()
            return;
        }


        const dialogId = `rating-names-list-${criterionId}`

        const numberOfUnlisted = total - userItems.length

        const dialogParams = {
            dialogId: dialogId,
            header: criterionName,
            userItems: (userItems.length > 0) ? userItems : null,
            footer: userItems.length > 0 && numberOfUnlisted > 0 ? AJS.I18n.getText('io.moewe.confluence.addons.rate.lastusers.more', numberOfUnlisted) : null
        }

        const dialogTemplate = MOEWE.Addons.ContentRating.View.NamesList.Soy.namesList(dialogParams)
        const dialog = this.dialogManager.openDialog(anchor, dialogTemplate, dialogId)

        this.namesLists[criterionId] = dialog

        dialog.open()
    }

    this.hideNamesList = (anchor, criterionId) => {
        const dialog = this.namesLists[criterionId]
        if (dialog != null) {
            dialog.close()
        }
    }

    this.refresh = () => {
        this.namesLists = {}
    }
}

window.addEventListener("MOEWE.Addons.ContentRating:hideRatingUserItems", event => {
    MOEWE.Addons.ContentRating.View.NamesList.hideNamesList(event.detail.anchor, event.detail.criterionId)
})

window.addEventListener("MOEWE.Addons.ContentRating:displayRatingUserItems", event => {
    MOEWE.Addons.ContentRating.View.NamesList.displayNamesList(event.detail.anchor, event.detail.criterionId,
        event.detail.criterionName, event.detail.userItems, event.detail.total)
})

window.addEventListener("MOEWE.Addons.ContentRating:refresh", () => {
    MOEWE.Addons.ContentRating.View.NamesList.refresh()
})

// Events to react on:
//
// Name:
//     "MOEWE.Addons.ContentRating:hideRatingUserItems"
// Params:
//     anchor: criterionElement,
//     criterionId: criterionId,
//     criterionName: criterionName,
//
// Name:
//     "MOEWE.Addons.ContentRating:displayRatingUserItems"
// Params:
//     anchor: criterionElement,
//     criterionId: criterionId,
//     criterionName: criterionName,
//     userItems: userItems[criterionId],
//     total: counts[criterionId]
