MOEWE.Addons.ContentRating.View.Toggle = function (obj, json) {
    MOEWE.Addons.ContentRating.View.call(this, obj, json); // super

    this._containerHtml.addClass("content-rating-toggle");
};

MOEWE.Addons.ContentRating.View.Toggle.prototype.initEvents = function (container) {
    let self = this;

    let contentRatingTitle = jQuery('.content-rating-title', container);
    AJS.$(contentRatingTitle).tooltip({gravity: 'n'});

    let contentRatingIcons = jQuery('.content-rating-icon', container);
    AJS.$(contentRatingIcons).tooltip({gravity: 's'});

    contentRatingIcons.click(function (event) {
        let item = jQuery(this);
        let value = (item.hasClass("content-rating-active")) ? 0 : 100;
        MOEWE.Addons.ContentRating.Common.addRating(self._obj, item, item.data('categoryId'), value);
    });

    contentRatingIcons.hover(function () {
        MOEWE.Addons.ContentRating.Common.setToggleTemplatesColorAttributes(jQuery(this), self._settings);
    }).mouseleave(function () {
        MOEWE.Addons.ContentRating.Common.setToggleTemplatesColorAttributes(jQuery(this), self._settings);
    });
}

MOEWE.inherit(MOEWE.Addons.ContentRating.View, MOEWE.Addons.ContentRating.View.Toggle);
