MOEWE.Addons.ContentRating.View.ToggleSmall = function (obj, json) {
    MOEWE.Addons.ContentRating.View.call(this, obj, json); // super

    this._containerHtml.addClass("content-rating-toggle-small");
};

MOEWE.Addons.ContentRating.View.ToggleSmall.prototype.initEvents = function (container) {
    let self = this;

    let contentRatingTitle = jQuery('.content-rating-title', container);
    AJS.$(contentRatingTitle).tooltip({gravity: 'n'});

    let contentRatingIcons = jQuery('.content-rating-icon', container);
    AJS.$(contentRatingIcons).tooltip({gravity: 's'});

    contentRatingIcons.click(function (event) {
        let item = jQuery(this);
        let value = (item.hasClass("content-rating-active")) ? 0 : 100;
        MOEWE.Addons.ContentRating.Common.addRating(self._obj, item, item.data('categoryId'), value);
    });

    contentRatingIcons.hover(function () {
        MOEWE.Addons.ContentRating.Common.setToggleTemplatesColorAttributes(jQuery(this), self._settings);
    }).mouseleave(function () {
        MOEWE.Addons.ContentRating.Common.setToggleTemplatesColorAttributes(jQuery(this), self._settings);
    });
}

MOEWE.Addons.ContentRating.View.ToggleSmall.prototype.getContentSoy = function (json) {
    return MOEWE.Addons.ContentRating.View.ToggleSmall;
}

MOEWE.inherit(MOEWE.Addons.ContentRating.View, MOEWE.Addons.ContentRating.View.ToggleSmall);
