MOEWE.Addons.ContentRating.View.Knob = function (obj, json) {
    MOEWE.Addons.ContentRating.View.call(this, obj, json); // super

    this._containerHtml.addClass("content-rating-knob");
};

MOEWE.Addons.ContentRating.View.Knob.prototype.initEvents = function ( container ) {
    var self = this;
    var ratingTimeout;

    var contentRatingTitle = jQuery('.content-rating-title', container);
    AJS.$(contentRatingTitle).tooltip({gravity: 'n'});

    var contentRatingSlider = jQuery('.content-rating-slider', container);
    AJS.$(contentRatingSlider).tooltip({gravity: 's'});

    var contentRatingKnob = jQuery('.content-rating-knob-trigger', container);

    contentRatingKnob.knob({
        height: 100,
        'release': function (value) {
            var item = this;
            var _self = self;
            clearTimeout(ratingTimeout);
            ratingTimeout = setTimeout(function () {
                MOEWE.Addons.ContentRating.Common.addRating(self._obj, item, item.$.data('categoryId'), value);
            }, 500);
        }
    });

    contentRatingKnob.focus(function () {
        jQuery(this).closest(".content-rating-slider").addClass("focus");
    });

    contentRatingKnob.blur(function () {
        jQuery(this).closest(".content-rating-slider").removeClass("focus");
    });
}

MOEWE.Addons.ContentRating.View.Knob.prototype.getContentSoy = function () {
    return MOEWE.Addons.ContentRating.View.Knob;
}

MOEWE.inherit(MOEWE.Addons.ContentRating.View, MOEWE.Addons.ContentRating.View.Knob);
