MOEWE.Addons.ContentRating.View.Feedback = MOEWE.Addons.ContentRating.View.Feedback || new function () {
    this.dialogManager = new MOEWE.Addons.ContentRating.InlineDialogManager()

    this.handleFeedback = (anchor, criterionId) => {
        document.querySelectorAll(".content-rating-feedback-dialog").forEach(dialog => {
            dialog.open = false;
            dialog.removeAttribute('open');
        });

        const dialogId = `content-rating-feedback-dialog-${criterionId}`

        let dialog = document.getElementById(dialogId);
        if (dialog) {
            new MOEWE.Addons.ContentRating.Dialog(dialog).open();
            return;
        }

        const settings = document.MOEWE_Addons_ContentRating.getSettings()
        const dialogParams = {
            dialogId: dialogId,
            alignment: 'bottom center',
            message: settings.feedbackDialogHeadline,
            acceptLabel: AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.settings.feedback.dialog.accept"),
            declineLabel: AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.settings.feedback.dialog.decline"),
            showFeedbackReceivedMessage: criterionId > 0
        }

        let feedbackAnchor = anchor.closest('.feedback-anchor');
        feedbackAnchor = feedbackAnchor ? feedbackAnchor : anchor.parentElement;

        const dialogTemplate = MOEWE.Addons.ContentRating.View.Feedback.Soy.feedback(dialogParams)
        dialog = this.dialogManager.openDialog(feedbackAnchor, dialogTemplate, dialogId)
        let dialogElem = dialog.dialogElement;

        jQuery("textarea[maxlength]").bind('input propertychange', function () {
            let maxLength = jQuery(this).attr('maxlength');
            if (jQuery(this).val().length > maxLength) {
                jQuery(this).val(jQuery(this).val().substring(0, maxLength));
            }
        });

        dialog.getDialogButtons = () => {
            return {
                accept: dialogElem.querySelector('[type="submit"]'),
                cancel: dialogElem.querySelector('a.cancel')
            }
        }

        dialog.getFeedbackMessage = () => dialogElem.querySelector('[name="message"]')?.value;
        dialog.open();

        const {accept, cancel} = dialog.getDialogButtons()

        // send feedback
        accept.addEventListener("click", (event) => {
            event.stopPropagation()
            event.preventDefault()

            const feedbackMessage = dialog.getFeedbackMessage();

            if (feedbackMessage) {
                AJS.$.ajax({
                    url: MOEWE.Addons.ContentRating.Common.getFeedbackUrl(),
                    type: "POST",
                    contentType: "application/json",
                    data: JSON.stringify({
                        rating: {
                            contentId: AJS.params.pageId,
                            criterionId: criterionId,
                        },
                        message: feedbackMessage
                    })
                }).done(json => {
                    AJS.flag({
                        type: 'success',
                        title: AJS.I18n.getText("io.moewe.confluence.addons.rate.feedback.success.title"),
                        body: '<p>' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedback.success.desc") + '</p>',
                        close: 'auto'
                    });
                    dialog.close()
                }).fail(moeweAjaxErrorCallback);
            }

            return false;
        })

        // close dialog
        cancel.addEventListener("click", (event) => {
            event.stopPropagation()
            event.preventDefault()
            dialog.close()
            return false;
        })

    }
};

window.addEventListener("MOEWE.Addons.ContentRating:openFeedback", event => MOEWE.Addons.ContentRating.View.Feedback.handleFeedback(event.detail.anchor, event.detail.criterionId))

