var ContentRatingStatistic = ContentRatingStatistic || {};

ContentRatingStatistic.getBaseUrl = () => {
    return `${AJS.params.baseUrl}/rest/content-rating/latest/statistic`
}

ContentRatingStatistic.export = function () {
    let spaceKeys = "";
    if (AJS.params.spaceKey) {
        spaceKeys = AJS.params.spaceKey;
    } else {
        let spaceKeysAttr = jQuery("#moewe-statistic-filter-container [name=spaceKeys]").val();
        if (typeof spaceKeysAttr !== 'undefined' && spaceKeysAttr != '') {
            spaceKeys = spaceKeysAttr;
        }
    }
    let title = jQuery("#moewe-statistic-filter-container [name=title]").val();
    window.location = AJS.params.baseUrl + '/plugins/servlet/content-rating/statistic/export?spaceKeys=' + encodeURIComponent(spaceKeys) + '&title=' + encodeURIComponent(title) + '&atl_token=' + AJS.params.atlToken;
    return false;
};

ContentRatingStatistic.reset = function () {
    let spaceKeys = "";
    if (AJS.params.spaceKey) {
        spaceKeys = AJS.params.spaceKey;
    } else {
        let spaceKeysAttr = jQuery("#moewe-statistic-filter-container [name=spaceKeys]").val();
        if (typeof spaceKeysAttr !== 'undefined' && spaceKeysAttr !== '') {
            spaceKeys = spaceKeysAttr;
        }
    }
    let title = jQuery("#moewe-statistic-filter-container [name=title]").val();

    var response = confirm(AJS.I18n.getText("io.moewe.confluence.addons.rate.statistic.reset.confirm"));
    if (response === true) {
        AJS.$.ajax({
            url: `${ContentRatingStatistic.getBaseUrl()}/reset?spaceKeys=${encodeURIComponent(spaceKeys)}&title=${encodeURIComponent(title)}`,
            success: function (msg) {
                AJS.flag({
                    type: 'success',
                    title: AJS.I18n.getText("io.moewe.confluence.addons.rate.statistic.reset.success.title"),
                    body: '<p>' + AJS.I18n.getText("io.moewe.confluence.addons.rate.statistic.reset.success") + '</p>',
                    close: 'auto'
                });
                location.reload()
                },
            error: moeweAjaxErrorCallback
            }
        );
    }
    return false;
};

ContentRatingStatistic.refreshDataTable = function () {
    var statisticTable = jQuery('#content-rating-statistic-table');
    statisticTable.DataTable().ajax.reload();
    return false;
};

jQuery(function () {
    var contentRatingStatisticTable = jQuery("#content-rating-statistic-table");
    var contentTypes = [];
    contentTypes["page"] = AJS.I18n.getText("io.moewe.confluence.addons.rate.statistic-macro.table.body.type.page");
    contentTypes["blogpost"] = AJS.I18n.getText("io.moewe.confluence.addons.rate.statistic-macro.table.body.type.blogpost");

    var columns = [];
    columns.push({
        "data": "title", "name": "title", "render": function (data, type, full, meta) {
            return '<a href="' + AJS.params.baseUrl + full.urlPath + '">' + data + '</a>';
        }
    });

    columns.push({
        "data": "type", "name": "type", "render": function (data, type, full, meta) {
            return contentTypes[data]
        }
    });

    if (AJS.params.spaceKey) {
        contentRatingStatisticTable.find("th.content-rating-space").remove();
    } else {
        columns.push({
            "data": "spaceName", "name": "spaceName", "render": function (data, type, full, meta) {
                return '<a href="' + AJS.params.baseUrl + '/' + full.spaceKey + '/">' + data + '</a>';
            }
        });
    }

    columns.push({"data": "userCount", "name": "rating.usercount"});

    jQuery(".content-rating-statistic-category", contentRatingStatisticTable).each(function (index) {
        var categoryId = jQuery(this).data("categoryId");
        columns.push({"data": "categoryItems." + index + ".count", "name": "rating.cat." + categoryId + ".count"});
        if (contentRatingStatisticTable.data("showRatingAverage")) {
            columns.push({
                "data": "categoryItems." + index + ".average",
                "name": "rating.cat." + categoryId + ".average"
            });
        }
    });


    if (jQuery(".content-rating-feedback").size() > 0) {
        columns.push({
            "data": "lastFeedback", "name": "rating.feedback.created", "render": function (data, type, full, meta) {
                return parseInt(data) == 0 ? "" : '<a href="' + AJS.params.baseUrl + '/pages/viewpagefeedback.action?pageId=' + full.contentId + '" class="aui-button aui-button-link" resolved="">' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedback.link.title") + '</span></a>'
            }
        });

        columns.push({
            "data": "unreadFeedback", "name": "rating.feedback.unread"
        });

        columns.push({
            "data": "openFeedback", "name": "rating.feedback.open"
        });
    }


    contentRatingStatisticTable.DataTable({
        "processing": true,
        "serverSide": true,
        "searching": false,
        "ajax": {
            "url": AJS.params.baseUrl + '/rest/content-rating/latest/statistic/list',
            "type": "GET",
            "data": function (data) {
                requestData = {};
                let spaceKeys = "";
                if (AJS.params.spaceKey) {
                    spaceKeys = AJS.params.spaceKey;
                } else {
                    let spaceKeysAttr = jQuery("#moewe-statistic-filter-container [name=spaceKeys]").val();
                    if (typeof spaceKeysAttr !== 'undefined' && spaceKeysAttr != '') {
                        spaceKeys = spaceKeysAttr;
                    }
                }


                requestData.spaceKeys = spaceKeys;
                requestData.title = jQuery("#moewe-statistic-filter-container [name=title]").val();
                requestData.atl_token = AJS.params.atlToken;
                requestData.limit = data.length;
                requestData.offset = data.start;
                requestData.order = data.order[0].dir;
                requestData.orderBy = data.columns[data.order[0].column].name;
                return requestData;
            },
        },
        "columns": columns,
        "order": [[0, "asc"]]
    });
});



