document.addEventListener("DOMContentLoaded", function () {

    let contentId = new URL(window.location.href).searchParams.get("pageId");

    if (contentId != null) {

        let containerId = "feedback-management";
        let restPath = "/content-rating";
        let fieldControllerPath = "/feedback";

        let feedbackManagement = new MOEWE.SDK.Components.EntityManagement({
            containerId: containerId,
            fieldControllerPath: fieldControllerPath,
            restPath: restPath,
            actions: ["DELETE"],
            itemViewHeader: '<tr><th width="10%">' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.header.criterion") + '</th><th width="5%">' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.header.criterion.status") + '</th><th width="45%">' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.header.message") + '</th><th width="10%" >' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.header.creator") + '</th><th width="10%" >' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.header.creationDate") + '</th><th width="25%" style="min-width: 260px;">' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.header.actions") + '</th></tr>',
            itemViewSettings: {
                text: {
                    noResults: '<tr><td colspan="5" class="content-rating-feedback-noResults" >' + AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.noResults") + '</td></tr>'
                },
                params: {
                    contentId: contentId
                },
                callback: {
                    renderItem: function (result) {
                        let attributeClass = '';
                        let readTrigger = '<a href="#" class="aui-button edit-feedback-trigger" data-feedback-id="' + result.id + '" data-feedback-field-name="read" data-feedback-field-value="false" >' + AJS.I18n.getText('io.moewe.confluence.addons.rate.feedbackManagement.action.unread') + '</a>';
                        let closeTrigger = '<a href="#" class="aui-button edit-feedback-trigger" data-feedback-id="' + result.id + '" data-feedback-field-name="archived" data-feedback-field-value="true" >' + AJS.I18n.getText('io.moewe.confluence.addons.rate.feedbackManagement.action.archived') + '</a>';

                        if (!result.read) {
                            attributeClass = 'class="content-rating-feedback-unread"';
                            readTrigger = '<a href="#" class="aui-button aui-button-primary edit-feedback-trigger" data-feedback-id="' + result.id + '" data-feedback-field-name="read" data-feedback-field-value="true" >' + AJS.I18n.getText('io.moewe.confluence.addons.rate.feedbackManagement.action.read') + '</a>';
                        }

                        if (result.archived) {
                            attributeClass = 'class="aui-row-subtle"';
                            closeTrigger = '<a href="#" class="aui-button edit-feedback-trigger" data-feedback-id="' + result.id + '" data-feedback-field-name="archived" data-feedback-field-value="false" >' + AJS.I18n.getText('io.moewe.confluence.addons.rate.feedbackManagement.action.restore') + '</a>';
                        }

                        let criterion = "";
                        let criterionStatus = "";
                        if (result.rating.criterionId > 0) {
                            if (result.rating.criterionIcon != "") {
                                criterion += '<i class="' + result.rating.criterionIcon + '"></i> ';
                            }
                            criterion += result.rating.criterionName;

                            if (result.rating.ratingValue === 0) {
                                criterionStatus = AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.criterion.status.removed");
                            } else {
                                criterionStatus = AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.criterion.status.added");
                            }
                        } else {
                            criterion += AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.criterion.no");
                        }

                        return '<tr ' + attributeClass + ' ><td>' + criterion + '</td><td>' + criterionStatus + '</td><td class="show-read-more">' + result.message + '</td><td>' + Confluence.Templates.User.usernameLink(result.rating.userItem) + '</td><td>' + result.formattedDate + '</td><td><div class="aui-buttons">' + readTrigger + ' ' + closeTrigger + '</div><div class="aui-buttons"><a href="#" class="aui-button aui-button-link delete-dialog-trigger" data-entity-id="' + result.id + '">' + AJS.I18n.getText("moewe-sdk.components.entity-management.delete") + '</a></div></td></tr>';
                    }
                }
            },
            text: {
                entityName: AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.entityName"),
                deleteConfirmMessage: AJS.I18n.getText("io.moewe.confluence.addons.rate.feedbackManagement.deleteConfirmMessage")
            }
        });

        document.addEventListener("moewe-sdk:afterEntityManagementRender", afterEntityManagementRender);
        document.addEventListener("moewe-sdk:afterEntityManagementRender", showReadMore);

        function afterEntityManagementRender(event) {
            if (event.detail.settings.containerId === containerId) {
                jQuery("#" + containerId + " table").addClass("display").addClass("fixedTable").removeClass("aui").removeClass("aui-table-list").DataTable({
                    retrieve: true,
                    searching: false,
                    "order": [[4, "desc"]]
                });
            }
        }

        let contentRatingFeedback = AJS.$("#" + containerId);
        contentRatingFeedback.on('click', ".edit-feedback-trigger", {feedbackManagement: feedbackManagement}, edit_feedback);

        function edit_feedback(event) {
            event.preventDefault();
            new MOEWE.SDK.Utils.Ajax({
                url: AJS.params.baseUrl + "/rest" + restPath + "/1.0" + fieldControllerPath + "/" + AJS.$(this).data("feedbackId") + "/" + AJS.$(this).data("feedbackFieldName"),
                method: "PUT",
                body: "" + AJS.$(this).data("feedbackFieldValue"),
                callback: {
                    success: function (request, response, settings) {
                        event.data.feedbackManagement.reload();
                    },
                    error: moeweAjaxErrorCallback
                }
            });
            return false;
        }

    }

    function showReadMore() {

        let maxLength = 140;
        document.querySelectorAll(".show-read-more").forEach(feedbackMessage => {

            let message = feedbackMessage.textContent;

            if (message.length > maxLength) {
                feedbackMessage.textContent = ""
                let visibleMessage = message.substr(0, maxLength);
                let hiddenMessage = message.substr(maxLength, message.length);

                feedbackMessage.textContent = visibleMessage;

                let readMoreButton = document.createElement("a");
                readMoreButton.href = "javascript:void(0);";
                readMoreButton.classList.add("read-more");
                readMoreButton.textContent = "Read More...";
                readMoreButton.style.maxWidth = "inherit";

                readMoreButton.addEventListener("click", function () {
                    feedbackMessage.textContent = visibleMessage + hiddenMessage;
                    readMoreButton.style.display = "none"
                });
                feedbackMessage.appendChild(readMoreButton);

            }
        })
    }
});

