AJS.toInit(function () {
    if (typeof MOEWE.Addons.ContentRating == "undefined") {
        return;
    }

    let settingsElement = document.querySelector('meta[name="moewe.content-rating"]');

    if (settingsElement != null) {
        document.MOEWE_Addons_ContentRating = new MOEWE.Addons.ContentRating(JSON.parse(settingsElement.content));
    }

    jQuery("#content-rating-reset-content-statistic-action").click(function () {
        return confirm('Do you really want to reset the statistics?');
    });

});


MOEWE.Addons.ContentRating = function (settings) {
    if (document.querySelectorAll('[data-content-rating-disabled=true]').length > 0) {
        return;
    }

    let self = this;
    this._view = null;
    this._settings = settings;

    jQuery(document).on("MOEWE.Addons.ContentRating:buildView", function (event, container) {
        container.attr("data-context", "macro");
        jQuery(".content-rating-wrapper[data-macro-name=content-rating-macro]").each(function (index) {
            let clone = container.clone();
            jQuery(this).append(clone);
            if (jQuery(this).data("disableGlobal") === true) {
                jQuery(".content-rating[data-context=\"global\"]").remove();
            }
            jQuery(document).trigger("MOEWE.Addons.ContentRating:viewRendered", [clone]);
        });
    });

    if (jQuery(settings.insertSelector).size() > 0) {
        if (settings.hasLikeCategory) {
            jQuery('#content').addClass("content-rating-hide-like");
        }
        jQuery.getJSON(MOEWE.Addons.ContentRating.Common.getRatingListUrl(), function (json) {
            self._view = self.buildView();
            self._view.init(json);
        });
    }

    if ('' !== settings.jiraIssueCollectorUrl) {

        window.ATL_JQ_PAGE_PROPS = jQuery.extend(window.ATL_JQ_PAGE_PROPS, {
            "triggerFunction": function (showCollectorDialog) {
                window.addEventListener('MOEWE.Addons.ContentRating:ratingAdded', (event) => {
                    event.preventDefault();
                    showCollectorDialog();
                });
            }
        });

        jQuery.ajax({
            url: settings.jiraIssueCollectorUrl,
            type: "get",
            cache: true,
            dataType: "script"
        });
    }
};

MOEWE.Addons.ContentRating.prototype.getSettings = function () {
    return this._settings;
};

MOEWE.Addons.ContentRating.prototype.refresh = function (json) {
    this._view.init(json);
};

MOEWE.Addons.ContentRating.Common = {
    addRating: function (obj, eventTarget, criterionId, value) {
        if (typeof criterionId == "undefined"
            || (AJS.Meta.get('remote-user') === "" && !obj._settings.anonymousVote)) {
            return;
        }

        AJS.$.ajax({
            url: MOEWE.Addons.ContentRating.Common.getRatingAddUrl(),
            type: "POST",
            contentType: "application/json",
            data: JSON.stringify({
                contentId: AJS.Meta.get('page-id'),
                criterionId: criterionId,
                ratingValue: value
            })
        }).done(function (json) {
            obj.refresh(json);
            let event = new CustomEvent("MOEWE.Addons.ContentRating:ratingAdded", {
                detail: {
                    criterionId: criterionId,
                    userCount: json?.userCount,
                    ratingId: json?.rating?.ratingId,
                    value: value,
                    obj: obj,
                }
            })
            window.dispatchEvent(event)

            const refreshEvent = new CustomEvent("MOEWE.Addons.ContentRating:refresh")
            window.dispatchEvent(refreshEvent)
        }).fail(moeweAjaxErrorCallback);
    },
    getRatingListUrl: function () {
        return AJS.Meta.get('base-url')
            + '/rest/content-rating/latest/rating/list?contentId=' + AJS.Meta.get('page-id');
    },
    getRatingAddUrl: function () {
        return AJS.Meta.get('base-url')
            + '/rest/content-rating/latest/rating/add';
    },
    getFeedbackUrl: function () {
        return AJS.Meta.get('base-url')
            + "/rest/content-rating/latest/feedback";
    },
    getLatestUsersUrl: function () {
        return AJS.Meta.get('base-url')
            + '/rest/content-rating/latest/rating/' + AJS.Meta.get('page-id') + '/latestUsers'
    },
    hasCurrentUserVoted: function (items) {
        var hasCurrentUserVoted = false;
        jQuery.each(items, function (index, item) {
            if (item.currentUserRating !== 0) {
                hasCurrentUserVoted = true;
                return false;
            }
        });
        return hasCurrentUserVoted;
    },
    setToggleTemplatesColorAttributes: function (item, settings) {
        if (item.hasClass("content-rating-active")) {
            item.css("background-color", settings.colors.outerCircle);
            item.css("color", "");
            if (item.is(":hover")) {
                item.css("border-color", settings.colors.bg);
            } else {
                item.css("border-color", settings.colors.outerCircle);
            }
        } else {
            item.css("background-color", "");
            item.css("color", settings.colors.text);

            if (item.is(":hover")) {
                item.css("border-color", settings.colors.outerCircle);
            } else {
                item.css("border-color", settings.colors.bg);
            }
        }
    },
    uniqueID: function () {
        let length = 8;
        let timestamp = +new Date;
        let _getRandomInt = function (min, max) {
            return Math.floor(Math.random() * (max - min + 1)) + min;
        };
        let ts = timestamp.toString();
        let parts = ts.split("").reverse();
        let id = "";
        for (let i = 0; i < length; ++i) {
            let index = _getRandomInt(0, parts.length - 1);
            id += parts[index];
        }
        return id;
    }
};

MOEWE.Addons.ContentRating.prototype.buildView = function () {
    let view;

    switch (this._settings.mode) {
        case "KNOB":
            view = new MOEWE.Addons.ContentRating.View.Knob(this);
            break;
        case "TOGGLE_SMALL":
            view = new MOEWE.Addons.ContentRating.View.ToggleSmall(this);
            break;
        case "STARS":
            view = new MOEWE.Addons.ContentRating.View.Stars(this);
            break;
        default:
            view = new MOEWE.Addons.ContentRating.View.Toggle(this);
    }

    let container = view.getContainer();
    let insertElement = jQuery(this._settings.insertSelector);
    if (insertElement.size() > 0) {
        if (this._settings.insertPlacement === "BEFORE") {
            insertElement.before(container);
        } else if (this._settings.insertPlacement === "APPEND") {
            insertElement.append(container);
        } else if (this._settings.insertPlacement === "PREPEND") {
            insertElement.prepend(container);
        } else {
            insertElement.after(container);
        }
    }

    jQuery(document).trigger("MOEWE.Addons.ContentRating:viewRendered", [container, view]);
    jQuery(document).trigger("MOEWE.Addons.ContentRating:buildView", [container.clone(), view]);

    return view;
};

MOEWE.Addons.ContentRating.View = function (obj) {

    let self = this;
    this._obj = obj;
    this._settings = obj.getSettings();

    this._containerHtml = jQuery("<div>", {
        "class": "content-rating",
        "data-view-id": MOEWE.Addons.ContentRating.Common.uniqueID(),
        "data-context": "global",
        "style": this._settings.insertStyle
    });

    this._build = function ({items, userCount, rating}) {
        const votedOnItems = items.filter(item => item.numberOfRatings > 0)
        let hasCurrentUserVoted = MOEWE.Addons.ContentRating.Common.hasCurrentUserVoted(items);
        let content = self.getContentSoy().Soy.content({
            headline: self._settings.headline,
            items: items,
            hasCurrentUserVoted: hasCurrentUserVoted,
            hideResult: self._settings.hideResult,
            hideOverall: self._settings.hideOverall,
            colors: self._settings.colors
        })

        if (AJS.Meta.get("remote-user") !== "" && (!self._settings.hideResult || (self._settings.hideResult && hasCurrentUserVoted))) {
            content = content
                + MOEWE.Addons.ContentRating.View.Preview.Soy.preview({
                    total: userCount,
                    hideOverall: self._settings.hideOverall
                });
        }


        if (this._settings.feedbackCollectorType === "FEEDBACKMANAGEMENT") {
            let viewFeedbackLink = document.getElementById("content-rating-feedback-management");
            content = content + MOEWE.Addons.ContentRating.View.Feedback.Soy.feedbackButtons({
                displayGiveFeedback: this._settings.feedbackRegardless,
                viewFeedbackLink: (viewFeedbackLink == null) ? null : viewFeedbackLink.getAttribute("href")
            })
        }

        return content
    }

}

MOEWE.Addons.ContentRating.View.prototype.getContainer = function () {
    return this._containerHtml;
};

MOEWE.Addons.ContentRating.View.prototype.getContentSoy = function () {
    return MOEWE.Addons.ContentRating.View.Toggle;
};

MOEWE.Addons.ContentRating.View.prototype.init = function (json) {
    let self = this;
    let viewId = this._containerHtml.data("viewId");
    let content = this._build(json);

    jQuery(".content-rating[data-view-id=\"" + viewId + "\"]").each(function (index) {
        let container = jQuery(this);
        container.html(content);
        self.initEvents(container);
    });

    if (AJS.Data.get("remote-user-key") !== "") {

        AJS.$.ajax({
            url: MOEWE.Addons.ContentRating.Common.getLatestUsersUrl(),
            type: "GET",
            contentType: "application/json",
        }).done(({criteriaLastUserItems, criteriaTotalUserCounts, lastUserItems, totalUserCounts}) => {
            const hasCurrentUserVoted = MOEWE.Addons.ContentRating.Common.hasCurrentUserVoted(json.items)
            const criterionHTMLItems = document.getElementsByClassName("content-rating-criterion")

            criterionHTMLItems.forEach(criterionElement => {
                const criterionId = criterionElement.dataset.criterionId
                const criterionName = criterionElement.dataset.criterionTitle
                let userItems;
                let total;
                if (criterionId === 0) {
                    userItems = lastUserItems;
                    total = totalUserCounts;
                } else {
                    userItems = criteriaLastUserItems[criterionId];
                    total = criteriaTotalUserCounts[criterionId];
                }

                criterionElement.addEventListener("mouseenter", event => {
                    if (!hasCurrentUserVoted) {
                        return;
                    }

                    const nameDisplayEvent = new CustomEvent("MOEWE.Addons.ContentRating:displayRatingUserItems", {
                        detail: {
                            anchor: criterionElement,
                            criterionId: criterionId,
                            criterionName: criterionName,
                            userItems: userItems,
                            total: total
                        }
                    })
                    window.dispatchEvent(nameDisplayEvent)
                })

                criterionElement.addEventListener("mouseleave", event => {
                    if (!hasCurrentUserVoted) {
                        return;
                    }

                    const nameHideEvent = new CustomEvent("MOEWE.Addons.ContentRating:hideRatingUserItems", {
                        detail: {
                            anchor: criterionElement.parentNode,
                            criterionId: criterionId,
                            criterionName: criterionName,
                        }
                    })
                    window.dispatchEvent(nameHideEvent)
                })
            })
        })

    }

    const feedbackTriggerHtml = document.getElementsByClassName("content-rating-feedback-trigger")

    if (feedbackTriggerHtml.length > 0) {

        feedbackTriggerHtml.forEach(feedbackTrigger => {
            feedbackTrigger.addEventListener("click", ev => {
                ev.stopPropagation()
                ev.preventDefault()

                const event = new CustomEvent("MOEWE.Addons.ContentRating:openFeedback", {
                    detail: {
                        anchor: ev.target,
                        criterionId: 0
                    }
                })
                window.dispatchEvent(event)
            })
        })

    }
};

MOEWE.Addons.ContentRating.View.prototype.initEvents = function (container) {
};

// Feedback
window.addEventListener('MOEWE.Addons.ContentRating:ratingAdded', (event) => {
    const settings = document.MOEWE_Addons_ContentRating.getSettings()
    const detail = event.detail

    if (settings.feedbackCollectorType !== "FEEDBACKMANAGEMENT") {
        return
    }

    const getContentRatingIcon = (criterionId) => {
        return document.getElementById("content-rating-criterion-" + criterionId).getElementsByClassName("content-rating-icon")[0]
    }

    const criterionId = detail.criterionId
    const anchor = getContentRatingIcon(criterionId);
    const feedbackEvent = new CustomEvent("MOEWE.Addons.ContentRating:openFeedback", {
        detail: {
            anchor: anchor,
            criterionId: criterionId,
        }
    })
    window.dispatchEvent(feedbackEvent)
})


