/**
 * TODO: Check, if this should be moved to SDK
 *
 * Use moeweAjaxErrorCallback.bind(String|Function) to set a custom string (used if response doesn't contain a message) or to use a custom function which is called as this(xhr, data)
 * @param xhr
 */
function moeweAjaxErrorCallback(xhr) {
    let data = {};
    try {
        data = JSON.parse(xhr.responseText);
    } catch (e) {
        if (xhr.responseText && xhr.responseText.trim() !== "") {
            data.message = xhr.responseText;
        }
    }

    let message = AJS.I18n.getText("com.moewe.common.errors.generic")

    if (data.message) {
        message = data.message;
    } else if (this instanceof String) {
        message = this.toString();
    } else if (this instanceof Function) {
        this(xhr, data);
    }

    AJS.flag({
        type: "error",
        title: AJS.I18n.getText("com.moewe.common.errors.generic.title"),
        body: message,
        close: 'auto'
    });
}

