var ContentRatingConfiguration = ContentRatingConfiguration || {};

ContentRatingConfiguration.getCategoriesBaseUrl = function () {
    return AJS.params.baseUrl + '/rest/content-rating/latest/criteria/';
};

ContentRatingConfiguration.getSettingsBaseUrl = function () {
    return AJS.params.baseUrl + '/rest/content-rating/latest/settings/';
};

ContentRatingConfiguration.getBaseUrlRatings = function () {
    return AJS.params.baseUrl + '/rest/content-rating/latest/rating/';
}

ContentRatingConfiguration.getBaseUrlFeedback = function () {
    return AJS.params.baseUrl + '/rest/content-rating/latest/feedback/';
}

ContentRatingConfiguration.exportRatings = function () {

    let active = jQuery('#settings-export-ratings-active').is(":checked");
    let start = jQuery('#export-ratings-start').val();
    let end = jQuery('#export-ratings-end').val();

    AJS.$.ajax({
            url: `${ContentRatingConfiguration.getBaseUrlRatings()}export?start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}&active=${encodeURIComponent(active)}&atl_token=${AJS.params.atlToken}`,
            success: function (data) {

                let blob = new Blob([data]);
                let link = document.createElement('a');
                let today = new Date();
                let date = today.getFullYear() + '-' + (today.getMonth() + 1) + '-' + today.getDate();
                let time = today.getHours() + "-" + today.getMinutes();
                let dateTime = date + '_' + time;
                link.href = window.URL.createObjectURL(blob);
                link.download = "export-ratings_" + dateTime + ".csv";
                link.click();

                AJS.flag({
                    type: 'success',
                    title: AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.export-ratings.settings.success.title"),
                    body: '<p>' + AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.export-ratings.settings.success") + '</p>',
                    close: 'auto'
                });

            },
            error: moeweAjaxErrorCallback.bind(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.export-ratings.settings.error"))
        }
    );
    return false;
};

ContentRatingConfiguration.deleteRatings = function () {

    let start = jQuery('#delete-ratings-start').val();
    let end = jQuery('#delete-ratings-end').val();

    let reallyDelete = confirm(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-ratings.confirm"));

    if (reallyDelete) {
        AJS.$.ajax({
            url: `${ContentRatingConfiguration.getBaseUrlRatings()}delete?start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}&atl_token=${AJS.params.atlToken}`,
            success: function () {
                AJS.flag({
                    type: 'success',
                    title: AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-ratings.success.title"),
                    body: '<p>' + AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-ratings.success") + '</p>',
                    close: 'auto'
                });
            },
            error: moeweAjaxErrorCallback.bind(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-ratings.error"))
        });
    }
    return false;
};

ContentRatingConfiguration.exportFeedback = function () {

    let start = jQuery('#export-feedback-start').val();
    let end = jQuery('#export-feedback-end').val();

    AJS.$.ajax({
            url: `${ContentRatingConfiguration.getBaseUrlFeedback()}export?start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}&atl_token=${AJS.params.atlToken}`,
            success: function (data) {

                var blob = new Blob([data]);
                var link = document.createElement('a');
                var today = new Date();
                var date = today.getFullYear() + '-' + (today.getMonth() + 1) + '-' + today.getDate();
                var time = today.getHours() + "-" + today.getMinutes();
                var dateTime = date + '_' + time;
                link.href = window.URL.createObjectURL(blob);
                link.download = "export-feedback_" + dateTime + ".csv";
                link.click();

                AJS.flag({
                    type: 'success',
                    title: AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.export-feedback.settings.success.title"),
                    body: '<p>' + AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.export-feedback.settings.success") + '</p>',
                    close: 'auto'
                });

            },
            error: moeweAjaxErrorCallback.bind(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.export-feedback.settings.error"))
        }
    );
    return false;
};

ContentRatingConfiguration.deleteFeedback = function () {

    let start = jQuery('#delete-feedback-start').val();
    let end = jQuery('#delete-feedback-end').val();

    let response = confirm(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-feedback.confirm"));

    if (response === true) {
        AJS.$.ajax({
            url: `${ContentRatingConfiguration.getBaseUrlFeedback()}delete?start=${encodeURIComponent(start)}&end=${encodeURIComponent(end)}&atl_token=${AJS.params.atlToken}`,
            success: function () {
                AJS.flag({
                    type: 'success',
                    title: AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-feedback.success.title"),
                    body: '<p>' + AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-feedback.success") + '</p>',
                    close: 'auto'
                });
            },
            error: moeweAjaxErrorCallback.bind(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.delete-feedback.error"))
        });
    }
    return false;
};

ContentRatingConfiguration.addCategory = function (formId) {
    const data = new FormData(document.getElementById(formId));
    const jsonData = JSON.stringify(Object.fromEntries(data.entries()));

    AJS.$.ajax({
            url: this.getCategoriesBaseUrl(),
            data: jsonData,
            type: "POST",
            contentType: "application/json",
            dataType: "json",
            success: function () {
                location.reload();
            },
            error: moeweAjaxErrorCallback
        }
    );
    return false;
};

ContentRatingConfiguration.updateCategory = function (categoryId) {
    const data = new FormData(document.getElementById('rate-edit-category-form-' + categoryId));
    let jsonData = JSON.stringify(Object.fromEntries(data.entries()));

    AJS.$.ajax({
            url: this.getCategoriesBaseUrl() + `${categoryId}`,
            data: jsonData,
            type: "PUT",
            contentType: "application/json",
            dataType: "json",
            success: function (msg) {
                location.reload();
            },
            error: moeweAjaxErrorCallback
        }
    );
    return false;
};

ContentRatingConfiguration.deleteCategory = function (categoryId) {
    let reallyRemove = confirm(AJS.I18n.getText("io.moewe.confluence.addons.rate.admin.config.categories.action.delete.really"));
    if (!reallyRemove) {
        return;
    }

    AJS.$.ajax({
        url: this.getCategoriesBaseUrl() + `${categoryId}`,
        type: "DELETE",
        data: null,
        success: function (msg) {
            location.reload();
        },
        error: moeweAjaxErrorCallback
    });
};

ContentRatingConfiguration.settings = function (formId) {
    const form = document.getElementById(formId);
    let jsonData = Object.fromEntries(new FormData(form).entries());
    jsonData.spaceKeys = jsonData.spaceKeys.split(",").map(key => key.trim());
    delete (jsonData['resetCategoryIds[]'])

    let resetCategoryIds = [];
    form.querySelectorAll('select[name="resetCategoryIds[]"] option').forEach(
        option => option.selected ? resetCategoryIds.push(option.value) : ''
    )
    if (resetCategoryIds.length > 0) {
        jsonData.resetCategoryIdsFromString = resetCategoryIds.join(",");
    }

    jsonData = JSON.stringify(jsonData);

    AJS.$.ajax({
            url: this.getSettingsBaseUrl(),
            type: "POST",
            data: jsonData,
            contentType: "application/json",
            dataType: "json",
            success: function (msg) {
                let successMessage = AJS.messages.success({
                    title: AJS.I18n.getText("com.moewe.common.success.save"),
                });
                jQuery(formId).before(successMessage.html);
                AJS.flag({
                    type: 'success',
                    body: '<p>' + AJS.I18n.getText("com.moewe.common.success.save") + '</p>',
                    close: 'auto'
                });
                successMessage.delay(2000).fadeOut('slow');
            },
            error: moeweAjaxErrorCallback
        }
    );
    return false;
};

ContentRatingConfiguration.addValue = function (inputSource, inputTarget) {
    var sourceVal = jQuery(inputSource).val();
    jQuery.trim(sourceVal);
    if (sourceVal.length > 0) {
        var targetVal = jQuery(inputTarget).val();
        jQuery.trim(targetVal);

        if (targetVal.length > 0) {
            jQuery(inputTarget).val(targetVal + ', ' + sourceVal);
        } else {
            jQuery(inputTarget).val(sourceVal);
        }

        jQuery(inputSource).val('');
    }
    return false;
};

jQuery(function () {

    function insertionSelectorToggleVisibility() {
        if (jQuery('input[name=insertionType]:checked').attr('id') == 'insertion-type-custom') {
            jQuery('#insertion-selector-wrapper').show();
        } else {
            jQuery('#insertion-selector-wrapper').hide();
        }
    }

    insertionSelectorToggleVisibility();

    jQuery('.insertion-type').click(function () {
        insertionSelectorToggleVisibility();
    });
});

AJS.toInit(() => {
    setupAnonymousLikeToggle();
    setupFeedbackToggle();
});

function setupAnonymousLikeToggle() {
    const ANONYMOUS_ACCESS = "settings-anonymous-access";
    const ANONYMOUS_LIKE_FIELD = "settings-anonymous-like-field";
    const ANONYMOUS_LIKE_CHECKBOX = "settings-anonymous-like";
    const accessSelect = document.getElementById(ANONYMOUS_ACCESS);
    accessSelect.addEventListener("change", (event) => {
        const value = AJS.$(event.target).val();
        if (value === "VOTE") {
            displayField(ANONYMOUS_LIKE_FIELD, true)
        } else {
            setChecked(ANONYMOUS_LIKE_CHECKBOX, false)
            displayField(ANONYMOUS_LIKE_FIELD, false)
        }
    });

    if (accessSelect.value != null && (accessSelect.value === "NONE" || accessSelect.value === "VIEW")) {
        setChecked(ANONYMOUS_LIKE_CHECKBOX, false)
        displayField(ANONYMOUS_LIKE_FIELD, false)
    }
}

function setupFeedbackToggle() {
    const FEEDBACK = "settings-feedback";
    const FEEDBACKMANAGEMENT = "feedback-collector-type-feedbackmanagement";
    const JIRAISSUECOLLECTOR = "feedback-collector-type-jiraissuecollector";

    const displayFields = (value) => {
        switch (value) {
            case "FEEDBACKMANAGEMENT": {
                displayField(JIRAISSUECOLLECTOR, false);
                displayField(FEEDBACKMANAGEMENT, true);
                break;
            }
            case "JIRAISSUECOLLECTOR": {
                displayField(FEEDBACKMANAGEMENT, false);
                displayField(JIRAISSUECOLLECTOR, true);
                break;
            }
            default : {
                displayField(JIRAISSUECOLLECTOR, false);
                displayField(FEEDBACKMANAGEMENT, false);
                break;
            }
        }
    };

    const feedbackSelect = document.getElementById(FEEDBACK);
    feedbackSelect.addEventListener("change", (event) => {
        const value = AJS.$(event.target).val();
        displayFields(value);
    });

    if (feedbackSelect.value != null) {
        displayFields(feedbackSelect.value)
    }
}


function displayField(id, show) {
    const element = document.getElementById(id);
    if (element == null) {
        return
    }

    if (show) {
        element.style.display = "block"
    } else {
        element.style.display = "none"
    }
}

function setChecked(id, checked) {
    const element = document.getElementById(id);
    if (element) {
        element.checked = checked;
    }
}
