/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;

public abstract class AnnotationParametersAbstractCheck
extends AbstractConstraintCheck {
    protected final AnnotationApiHelper annotationApiHelper;
    private Set<String> annotationClasses;

    public AnnotationParametersAbstractCheck(AnnotationApiHelper annotationApiHelper, String ... annotationClass) {
        this.annotationApiHelper = annotationApiHelper;
        this.annotationClasses = new HashSet<String>(Arrays.asList(annotationClass));
    }

    @Override
    public Set<ConstraintCheckIssue> checkField(VariableElement element, AnnotationMirror annotation) {
        return this.checkAnnotation(element, annotation);
    }

    @Override
    public Set<ConstraintCheckIssue> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        return this.checkAnnotation(element, annotation);
    }

    @Override
    public Set<ConstraintCheckIssue> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        return this.checkAnnotation(element, annotation);
    }

    @Override
    public Set<ConstraintCheckIssue> checkNonAnnotationType(TypeElement element, AnnotationMirror annotation) {
        return this.checkAnnotation(element, annotation);
    }

    protected boolean canCheckThisAnnotation(AnnotationMirror annotation) {
        return this.annotationClasses.contains(annotation.getAnnotationType().asElement().toString());
    }

    private Set<ConstraintCheckIssue> checkAnnotation(Element element, AnnotationMirror annotation) {
        if (this.canCheckThisAnnotation(annotation)) {
            return this.doCheck(element, annotation);
        }
        return Collections.emptySet();
    }

    protected abstract Set<ConstraintCheckIssue> doCheck(Element var1, AnnotationMirror var2);
}

