/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.util;

import io.moewe.confluence.addons.rate.rest.pojo.Criterion;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lio/moewe/confluence/addons/rate/util/SanitizationHelper;", "", "<init>", "()V", "Companion", "rate"})
public final class SanitizationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] INVALID_LABEL_CHARACTERS;

    static {
        String[] stringArray = new String[]{":", ";", ".", "?", "&", "[", "]", "(", ")", "#", "^", "*", "@", "!", "<", ">", " "};
        INVALID_LABEL_CHARACTERS = stringArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lio/moewe/confluence/addons/rate/util/SanitizationHelper$Companion;", "", "<init>", "()V", "INVALID_LABEL_CHARACTERS", "", "", "[Ljava/lang/String;", "sanitizeLabels", "labels", "sanitizeCriterion", "Lio/moewe/confluence/addons/rate/rest/pojo/Criterion;", "criterion", "trim", "content", "rate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String sanitizeLabels(@Nullable String labels) {
            String sanitizedLabels = this.trim(labels);
            for (String invalidLabelCharacter : INVALID_LABEL_CHARACTERS) {
                sanitizedLabels = StringsKt.replace$default(sanitizedLabels, invalidLabelCharacter, "", false, 4, null);
            }
            String string = sanitizedLabels.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return string;
        }

        @NotNull
        public final Criterion sanitizeCriterion(@NotNull Criterion criterion) {
            Intrinsics.checkNotNullParameter(criterion, "criterion");
            Criterion sanitized = new Criterion();
            sanitized.setId(criterion.getId());
            sanitized.setEnabled(criterion.isEnabled());
            sanitized.setOrder(criterion.getOrder());
            sanitized.setName(this.trim(criterion.getName()));
            sanitized.setDescription(this.trim(criterion.getDescription()));
            sanitized.setFontawesome(this.trim(criterion.getFontawesome()));
            sanitized.setSpaceLabelFilter(this.sanitizeLabels(criterion.getSpaceLabelFilter()));
            sanitized.setContentLabelFilter(this.sanitizeLabels(criterion.getContentLabelFilter()));
            return sanitized;
        }

        private final String trim(String content) {
            String string = content;
            if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                string = "";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

