/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.util;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class RatingUserHelper {
    private static final String KEY_ANONYMOUS_UUID = "io.moewe.confluence.addons.rate.anonymous.uuid";

    public static String getCurrentUserKey(Settings settings) {
        if (RatingUserHelper.isAnonymous() || settings.isAnonymousRatingForLoggedInUser()) {
            HttpSession session = ServletContextThreadLocal.getRequest().getSession(true);
            UUID anonymousUUID = (UUID)session.getAttribute(KEY_ANONYMOUS_UUID);
            if (anonymousUUID == null) {
                anonymousUUID = RatingUserHelper.getAnonymousUUIDFromCookies(settings);
                session.setAttribute(KEY_ANONYMOUS_UUID, (Object)anonymousUUID);
            }
            return anonymousUUID.toString();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return user != null ? user.getKey().toString() : null;
    }

    public static boolean isAnonymous() {
        return AuthenticatedUserThreadLocal.isAnonymousUser();
    }

    private static UUID getAnonymousUUIDFromCookies(Settings settings) {
        UUID anonymousUUID = null;
        Cookie[] cookies = ServletContextThreadLocal.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(KEY_ANONYMOUS_UUID)) continue;
                anonymousUUID = UUID.fromString(cookie.getValue());
                break;
            }
        }
        if (anonymousUUID == null) {
            anonymousUUID = UUID.randomUUID();
            Cookie cookie = new Cookie(KEY_ANONYMOUS_UUID, anonymousUUID.toString());
            cookie.setMaxAge(settings.getAnonymousSessionExpiration());
            cookie.setValue(anonymousUUID.toString());
            ServletContextThreadLocal.getResponse().addCookie(cookie);
        }
        return anonymousUUID;
    }
}

