/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LimitedSizeListMap<K, V>
extends AbstractMap<K, List<V>> {
    private final HashMap<K, List<V>> delegateMap = new HashMap();
    private Integer limit = null;

    public void setLimit(int limit) {
        this.limit = Math.max(0, limit);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        if (this.limit != null && this.limit > 0) {
            return this.delegateMap.put(key, value.subList(0, Math.min(value.size(), this.limit)));
        }
        return this.delegateMap.put(key, value);
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.delegateMap.entrySet();
    }

    public List<V> append(K key, V value) {
        List values2 = this.delegateMap.getOrDefault(key, new ArrayList());
        if (this.limit != null && this.limit > 0) {
            if (values2.size() < this.limit) {
                values2.add(value);
            }
        } else {
            values2.add(value);
        }
        return this.put(key, values2);
    }
}

