/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.servlet;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.StatisticService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReportServlet
extends HttpServlet {
    private final TemplateRenderer renderer;
    private final BootstrapManager bootstrapManager;
    private final MoeweLicenseService licenseService;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final PageBuilderService pageBuilderService;
    private final PersistenceService persistenceService;
    private final CategoryService categoryService;
    private final StatisticService statisticService;

    public ReportServlet(@ComponentImport TemplateRenderer renderer, @ComponentImport BootstrapManager bootstrapManager, MoeweLicenseService licenseService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PageBuilderService pageBuilderService, PersistenceService persistenceService, CategoryService categoryService, StatisticService statisticService) {
        this.renderer = renderer;
        this.bootstrapManager = bootstrapManager;
        this.licenseService = licenseService;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pageBuilderService = pageBuilderService;
        this.persistenceService = persistenceService;
        this.categoryService = categoryService;
        this.statisticService = statisticService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        this.pageBuilderService.assembler().resources().requireContext("io.moewe.confluence.addons.rate.statistic-macro");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("ratingCategories", this.categoryService.getCategories(true));
        Settings settings = this.persistenceService.getSettings();
        context.put("isFeedbackManagement", settings.getFeedbackCollectorType().equals((Object)Settings.FeedbackCollectorType.FEEDBACKMANAGEMENT));
        context.put("showRatingAverage", this.persistenceService.showAverage());
        context.put("showContentType", settings.isPageEnabled() && settings.isBlogpostEnabled());
        context.put("canResetRatings", this.statisticService.canReset());
        context.put("categories", this.categoryService.getCategories(false));
        context.put("settings", this.persistenceService.getSettings());
        context.put("isLicenseInvalid", !this.licenseService.isValid());
        context.put("webAppContext", this.bootstrapManager.getWebAppContextPath());
        this.renderer.render("moewe-content-rating-vm/report.html.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

