/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.rest.pojo.CategoryItem;
import io.moewe.confluence.addons.rate.rest.pojo.StatisticItem;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.StatisticResults;
import io.moewe.confluence.addons.rate.service.StatisticService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportStatisticServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportStatisticServlet.class);
    private static final String I18N_TABLE_HEAD_PREFIX = "io.moewe.confluence.addons.rate.statistic-macro.table.head.";
    private static final String QUOTE = "\"";
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final StatisticService statisticService;
    private final PersistenceService persistenceService;
    private final CategoryService categoryService;
    private final I18nResolver i18nResolver;

    public ExportStatisticServlet(UserManager userManager, LoginUriProvider loginUriProvider, StatisticService statisticService, PersistenceService persistenceService, CategoryService categoryService, I18nResolver i18nResolver) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.statisticService = statisticService;
        this.persistenceService = persistenceService;
        this.categoryService = categoryService;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            response.setContentType("text/csv; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            String paramSpaceKeys = request.getParameter("spaceKeys");
            HashSet<String> spaceKeys = new HashSet();
            if (StringUtils.isNotBlank((String)paramSpaceKeys)) {
                paramSpaceKeys = paramSpaceKeys.replace(" ", "");
                spaceKeys = new HashSet<String>(Arrays.asList(paramSpaceKeys.split(",")));
            }
            boolean showAverage = this.persistenceService.showAverage();
            String seperator = this.persistenceService.getSettings().getStatisticExportSeperator();
            outputStream.write(this.generateHead(showAverage, seperator).getBytes());
            response.setHeader("Content-Disposition", "attachment; filename=export.csv");
            this.generateBody(showAverage, seperator, (OutputStream)outputStream, spaceKeys, request.getParameter("title"), 0, 500);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Exception while generating excel export", (Throwable)e);
        }
    }

    private String generateHead(boolean showAverage, String seperator) {
        StringBuilder outputResult = new StringBuilder();
        outputResult.append(QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.content.title")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.content.type")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.space.name")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.space.key")).append(QUOTE);
        outputResult.append(seperator).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.number-of-rated-users"));
        for (CategoryEntity category : this.categoryService.getCategories(true)) {
            if (showAverage) {
                outputResult.append(seperator + QUOTE).append(category.getCategoryName()).append(" ").append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.ratings")).append(QUOTE);
                outputResult.append(seperator + QUOTE).append(category.getCategoryName()).append(" ").append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.statistic-macro.table.head.average")).append(QUOTE);
                continue;
            }
            outputResult.append(seperator + QUOTE).append(category.getCategoryName()).append(QUOTE);
        }
        outputResult.append("\n");
        LOGGER.debug(outputResult.toString());
        return outputResult.toString();
    }

    private void generateBody(boolean showAverage, String seperator, OutputStream outputStream, Set<String> spaceKeys, String title, int offset, int limit) throws IOException {
        StatisticResults statisticResults = this.statisticService.getStatisticResults(spaceKeys, title, offset, limit, null, null);
        if (statisticResults.getData().size() > 0) {
            StringBuilder outputResultBuilder = new StringBuilder();
            for (StatisticItem statisticItem : statisticResults.getData()) {
                outputResultBuilder.append(QUOTE).append(statisticItem.getTitle()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(statisticItem.getType()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(statisticItem.getSpaceName()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(statisticItem.getSpaceKey()).append(QUOTE);
                outputResultBuilder.append(seperator).append(statisticItem.getUserCount());
                List<CategoryItem> categoryStatisticItems = statisticItem.getCategoryItems();
                for (CategoryItem categoryStatisticItem : categoryStatisticItems) {
                    outputResultBuilder.append(seperator).append(categoryStatisticItem.getCount());
                    if (!showAverage) continue;
                    outputResultBuilder.append(seperator).append(categoryStatisticItem.getAverage());
                }
                outputResultBuilder.append("\n");
            }
            outputStream.write(outputResultBuilder.toString().getBytes());
            if (statisticResults.getRecordsTotal() > offset + limit) {
                this.generateBody(showAverage, seperator, outputStream, spaceKeys, title, offset + limit, limit);
            }
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

