/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.servlet;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import io.moewe.atlassian.sdk.internal.license.MoeweLicenseService;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfigurationServlet
extends HttpServlet {
    private static final String CONTEXT_ADMIN_RESOURCES = "io.moewe.confluence.addons.rate:rate-admin-resources";
    private static final String CONTEXT_STATISTIC_MACRO_RESOURCES = "io.moewe.confluence.addons.rate:statistic-macro-resources";
    private static final String CONTEXT_AUI_SELECT2 = "com.atlassian.auiplugin:aui-select2";
    private final BootstrapManager bootstrapManager;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final CategoryService categoryService;
    private final PersistenceService persistenceService;
    private final MoeweLicenseService licenseService;
    private final PageBuilderService pageBuilderService;
    private final PluginAccessor pluginAccessor;

    @Inject
    public ConfigurationServlet(CategoryService categoryService, PersistenceService persistenceService, MoeweLicenseService licenseService, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport PluginAccessor pluginAccessor) {
        this.bootstrapManager = bootstrapManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.categoryService = categoryService;
        this.persistenceService = persistenceService;
        this.licenseService = licenseService;
        this.pageBuilderService = pageBuilderService;
        this.pluginAccessor = pluginAccessor;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null || !this.userManager.isAdmin(user)) {
            this.redirectToLogin(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        RequiredResources resources = this.pageBuilderService.assembler().resources();
        resources.requireWebResource(CONTEXT_AUI_SELECT2);
        resources.requireWebResource(CONTEXT_ADMIN_RESOURCES);
        resources.requireWebResource(CONTEXT_STATISTIC_MACRO_RESOURCES);
        resources.requireContext("moewe.sdk.font-icon-selector");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("ratingCategories", this.categoryService.getCategories(true));
        Settings settings = this.persistenceService.getSettings();
        context.put("showRatingAverage", this.persistenceService.showAverage());
        context.put("showContentType", settings.isPageEnabled() && settings.isBlogpostEnabled());
        context.put("categories", this.categoryService.getCategories(false));
        context.put("settings", this.persistenceService.getSettings());
        context.put("isLicenseInvalid", !this.licenseService.isValid());
        context.put("webAppContext", this.bootstrapManager.getWebAppContextPath());
        Plugin plugin = this.pluginAccessor.getPlugin("io.moewe.confluence.addons.rate");
        context.put("urlPluginName", URLEncoder.encode(plugin.getName() + " for Confluence", "UTF-8"));
        context.put("urlPluginVersion", URLEncoder.encode(plugin.getPluginInformation().getVersion(), "UTF-8"));
        context.put("urlProductVersion", URLEncoder.encode(GeneralUtil.getVersionNumber(), "UTF-8"));
        this.renderer.render("moewe-content-rating-vm/admin/configuration.html.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

