/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.service;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.SiteSearchPermissionsQueryFactory;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentPermissionsQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.MultiTextFieldQuery;
import com.atlassian.confluence.search.v2.sort.LowercaseFieldSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.rest.pojo.StatisticItem;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.ConfluenceServices;
import io.moewe.confluence.addons.rate.service.FeedbackService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.RatingService;
import io.moewe.confluence.addons.rate.service.StatisticResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class StatisticService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticService.class);
    private final FeedbackService feedbackService;
    private final PermissionManager permissionManager;
    private final CategoryService categoryService;
    private final SearchManager searchManager;
    private final PersistenceService persistenceService;
    private final RatingService ratingService;
    private final I18nResolver i18nResolver;
    private final AccessModeService accessModeService;
    private final ConfluenceServices services;
    private final SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory;

    @Inject
    public StatisticService(CategoryService categoryService, FeedbackService feedbackService, PersistenceService persistenceService, RatingService ratingService, @ComponentImport SearchManager searchManager, @ComponentImport PermissionManager permissionManager, I18nResolver i18nResolver, AccessModeService accessModeService, ConfluenceServices services, @ComponentImport SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory) {
        this.feedbackService = feedbackService;
        this.permissionManager = permissionManager;
        this.categoryService = categoryService;
        this.searchManager = searchManager;
        this.persistenceService = persistenceService;
        this.ratingService = ratingService;
        this.i18nResolver = i18nResolver;
        this.accessModeService = accessModeService;
        this.services = services;
        this.siteSearchPermissionsQueryFactory = siteSearchPermissionsQueryFactory;
    }

    public StatisticResults getStatisticResults(Set<String> spaceKeys, String title, int offset, int limit, String order, String orderBy) {
        SearchQuery query = this.getContentTypeQuery();
        if (spaceKeys != null && !spaceKeys.isEmpty()) {
            query = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{query, new InSpaceQuery(spaceKeys)});
        }
        if (StringUtils.isNotBlank((String)title)) {
            query = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{query, BooleanQuery.orQuery((SearchQuery[])new SearchQuery[]{new MultiTextFieldQuery(title, new String[]{"title"}), new MultiTextFieldQuery(title + "*", new String[]{"title"})})});
        }
        SearchSort.Order searchOrder = SearchSort.Order.ASCENDING;
        if (order != null && order.equals("desc")) {
            searchOrder = SearchSort.Order.DESCENDING;
        }
        TitleSort searchSort = new TitleSort(searchOrder);
        if (orderBy != null) {
            orderBy = "spaceName".equals(orderBy) ? "spacekey" : orderBy;
            searchSort = new LowercaseFieldSort(orderBy, searchOrder);
        }
        try {
            ArrayList<StatisticItem> statisticItems = new ArrayList<StatisticItem>();
            int recordsTotal = 0;
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            query = user != null && this.hasGlobalStatisticPermissions(user.getKey()) ? BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{query, ContentPermissionsQuery.builder().user(user).build()}) : BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{query, this.siteSearchPermissionsQueryFactory.create()});
            List<SearchResults> allSearchResults = this.search(query, (SearchSort)searchSort, offset, limit);
            for (SearchResults searchResults : allSearchResults) {
                recordsTotal = searchResults.getUnfilteredResultsCount();
                for (SearchResult searchResult : searchResults.getAll()) {
                    statisticItems.add(new StatisticItem(searchResult, this.categoryService.getCategories(true), this.ratingService, this.feedbackService));
                }
            }
            return new StatisticResults((List<StatisticItem>)statisticItems, recordsTotal);
        }
        catch (InvalidSearchException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public StatisticResults getStatisticResults(Set<String> spaceKeys, String title) {
        return this.getStatisticResults(spaceKeys, title, 0, 500, null, null);
    }

    public void resetStatistic(Set<String> spaceKeys, String title) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.statistic.reset.banner.message"));
        }
        if (!this.canReset()) {
            return;
        }
        this.resetStatistic(spaceKeys, title, 0, 500);
    }

    private void resetStatistic(Set<String> spaceKeys, String title, int offset, int limit) {
        StatisticResults statisticResults = this.getStatisticResults(spaceKeys, title, offset, limit, null, null);
        for (StatisticItem statisticItem : statisticResults.getData()) {
            ContentEntityObject contentEntityObject;
            Space space = this.services.getSpaceManager().getSpace(statisticItem.getSpaceKey());
            if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space) || (contentEntityObject = this.services.getPageManager().getById(statisticItem.getContentId().longValue())) == null) continue;
            this.ratingService.resetContentStatistic(contentEntityObject, new ArrayList<Integer>());
        }
        if (statisticResults.getRecordsTotal() > offset + 500) {
            this.resetStatistic(spaceKeys, title, offset + limit, limit);
        }
    }

    private List<SearchResults> search(SearchQuery query, SearchSort sort, int offset, int limit) throws InvalidSearchException {
        ArrayList<SearchResults> allSearchResults = new ArrayList<SearchResults>();
        SearchResults searchResults = this.searchManager.search((ISearch)new ContentSearch(query, sort, offset, limit));
        allSearchResults.add(searchResults);
        return allSearchResults;
    }

    private SearchQuery getContentTypeQuery() {
        Settings settings = this.persistenceService.getSettings();
        if (settings.isPageEnabled() && settings.isBlogpostEnabled()) {
            return BooleanQuery.orQuery((SearchQuery[])new SearchQuery[]{new ContentTypeQuery(ContentTypeEnum.PAGE), new ContentTypeQuery(ContentTypeEnum.BLOG)});
        }
        if (settings.isPageEnabled()) {
            return BooleanQuery.orQuery((SearchQuery[])new SearchQuery[]{new ContentTypeQuery(ContentTypeEnum.PAGE)});
        }
        if (settings.isBlogpostEnabled()) {
            return BooleanQuery.orQuery((SearchQuery[])new SearchQuery[]{new ContentTypeQuery(ContentTypeEnum.BLOG)});
        }
        return null;
    }

    public boolean canReset() {
        Settings settings = this.persistenceService.getSettings();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return settings.isResettableSpaceStatistic() && (this.services.getUserManager().isAdmin(user.getKey()) || settings.isStatisticUserGroupsCanReset() && this.hasGlobalStatisticPermissions(user.getKey()));
    }

    public boolean hasGlobalStatisticPermissions(UserKey userKey) {
        if (userKey == null) {
            return false;
        }
        if (this.services.getUserManager().isAdmin(userKey)) {
            return true;
        }
        String statisticUserGroup = this.persistenceService.getSettings().getStatisticUserGroups();
        if (statisticUserGroup != null && !statisticUserGroup.isBlank()) {
            HashSet<String> statisticUserGroups = new HashSet<String>(Arrays.asList(statisticUserGroup.split(",")));
            for (String userGroup : statisticUserGroups) {
                if (!this.services.getUserManager().isUserInGroup(userKey, userGroup.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

