/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bonnie.Searchable;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import io.moewe.atlassian.sdk.internal.util.BatchHelper;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.ao.FeedbackEntity;
import io.moewe.confluence.addons.rate.ao.RatingEntity;
import io.moewe.confluence.addons.rate.rest.RatingResource;
import io.moewe.confluence.addons.rate.rest.pojo.Rating;
import io.moewe.confluence.addons.rate.rest.pojo.RatingItem;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.rest.pojo.UserItem;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.util.RatingUserHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class RatingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingService.class);
    private static final int LIKE_RATING_VALUE = 100;
    private static final int DEFAULT_USER_RATING_VALUE = 0;
    private static final int LATEST_USER_LIMIT = 10;
    private static final String I18N_TABLE_HEAD_PREFIX = "io.moewe.confluence.addons.rate.export-ratings.table.head.";
    private static final String QUOTE = "\"";
    private static final int DEFAULT_OFFSET = 0;
    private final ActiveObjects activeObjects;
    private final CategoryService categoryService;
    private final PersistenceService persistenceService;
    private final PageManager pageManager;
    private final LikeManager likeManager;
    private final ConfluenceIndexer confluenceIndexer;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final Cache<String, Double> averageCache;
    private final Cache<Long, Integer> userCountCache;
    private final Cache<String, Integer> categoryCountCache;
    private final Cache<Long, RatingItem> ratingItemCache;
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final AccessModeService accessModeService;

    @Inject
    public RatingService(CategoryService categoryService, PersistenceService persistenceService, @ComponentImport ActiveObjects activeObjects, @ComponentImport PageManager pageManager, @ComponentImport LikeManager likeManager, @ComponentImport CacheManager cacheManager, @ComponentImport @Qualifier(value="confluenceIndexer") ConfluenceIndexer confluenceIndexer, @ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport UserManager userManager, AccessModeService accessModeService) {
        this.activeObjects = activeObjects;
        this.pageManager = pageManager;
        this.categoryService = categoryService;
        this.persistenceService = persistenceService;
        this.likeManager = likeManager;
        this.confluenceIndexer = confluenceIndexer;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.accessModeService = accessModeService;
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterAccess(24L, TimeUnit.HOURS).remote().build();
        this.ratingItemCache = cacheManager.getCache(RatingResource.class.getName() + ".ratingItem.cache", (CacheLoader)new RatingItemCacheLoader(), cacheSettings);
        this.averageCache = cacheManager.getCache(RatingService.class.getName() + ".average.cache", (CacheLoader)new AverageCacheLoader(), cacheSettings);
        this.userCountCache = cacheManager.getCache(RatingService.class.getName() + ".userCount.cache", (CacheLoader)new UserCountCacheLoader(), cacheSettings);
        this.categoryCountCache = cacheManager.getCache(RatingService.class.getName() + ".categoryCount.cache", (CacheLoader)new CategoryCountCacheLoader(), cacheSettings);
    }

    public RatingEntity getUserRating(long contentId, int criterionId, boolean ignoreUnanonymousLikes) {
        CategoryEntity category = this.categoryService.getCriterion(criterionId);
        if (category == null) {
            LOGGER.warn("User {} tried to access a non-existent category {}", (Object)RatingUserHelper.getCurrentUserKey(this.persistenceService.getSettings()), (Object)criterionId);
            return null;
        }
        ArrayList<Integer> criteriaIds = new ArrayList<Integer>();
        criteriaIds.add(criterionId);
        RatingEntity[] ratings = this.getRatings(contentId, criteriaIds, true, ignoreUnanonymousLikes);
        return ratings.length > 0 ? ratings[0] : null;
    }

    private RatingEntity[] getRatings(Long contentId, List<Integer> categoryIds, boolean onlyUser, boolean ignoreUnanonymousLikes) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Object clause = "CATEGORYID IS NOT NULL AND ACTIVE = ? ";
        parameters.add(Boolean.TRUE);
        Settings settings = this.persistenceService.getSettings();
        if (contentId != null) {
            clause = (String)clause + " AND CONTENT_ID = ?";
            parameters.add(contentId);
        }
        if (categoryIds != null && categoryIds.size() > 0) {
            String in = categoryIds.parallelStream().map(n -> "?").collect(Collectors.joining(","));
            clause = (String)clause + " AND CATEGORYID IN (" + in + ")";
            parameters.addAll(categoryIds);
        }
        if (onlyUser) {
            clause = (String)clause + " AND USER_KEY = ?";
            parameters.add(RatingUserHelper.getCurrentUserKey(settings));
        }
        if (ignoreUnanonymousLikes) {
            clause = (String)clause + " AND (ANONYMOUS_USER = ?  OR CATEGORYID != ?)";
            parameters.add(Boolean.TRUE);
            parameters.add(settings.getLikeCategoryId());
        }
        return (RatingEntity[])this.activeObjects.find(RatingEntity.class, Query.select().where((String)clause, parameters.toArray()));
    }

    public RatingEntity[] getLastRatings(Long contentId, Integer criterionId, int limit) {
        ArrayList<Serializable> parameters = new ArrayList<Serializable>();
        Object clause = "CATEGORYID IS NOT NULL ";
        if (limit < 0 || limit > 10) {
            limit = 10;
        }
        if (criterionId == null) {
            LOGGER.warn("Retrieving last ratings without given criterionId is not possible.");
            return null;
        }
        clause = (String)clause + " AND CATEGORYID = ?";
        parameters.add(criterionId);
        if (contentId != null) {
            clause = (String)clause + " AND CONTENT_ID = ?";
            parameters.add(contentId);
        }
        clause = (String)clause + " AND ACTIVE = ? ";
        parameters.add(Boolean.TRUE);
        return (RatingEntity[])this.activeObjects.find(RatingEntity.class, Query.select().where((String)clause, parameters.toArray()).order("LAST_MODIFICATION DESC").limit(limit));
    }

    public void deleteRating(RatingEntity ratingEntity) {
        if (ratingEntity == null) {
            return;
        }
        long contentId = ratingEntity.getContentId();
        BatchHelper.process(this.activeObjects, Query.select().where("RATINGID = ?", new Object[]{ratingEntity.getID()}), FeedbackEntity.class, ActiveObjects::delete, 0, false);
        this.activeObjects.delete(new RawEntity[]{ratingEntity});
        ContentEntityObject contentEntityObject = this.pageManager.getById(contentId);
        if (contentEntityObject == null) {
            return;
        }
        this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
        LOGGER.debug("Rating deleted: {}", (Object)ratingEntity);
    }

    public RatingEntity[] getRatings(int offset, int limit, boolean active, Long millisStart, Long millisEnd) {
        ArrayList<Comparable<Boolean>> parameters = new ArrayList<Comparable<Boolean>>();
        Object clause = "ACTIVE = ? ";
        if (active) {
            parameters.add(Boolean.TRUE);
        } else {
            parameters.add(Boolean.FALSE);
        }
        if (millisStart != null && millisEnd != null) {
            clause = (String)clause + " AND LAST_MODIFICATION BETWEEN ? ";
            parameters.add(millisStart);
            clause = (String)clause + " AND ? ";
            parameters.add(millisEnd);
        }
        return (RatingEntity[])this.activeObjects.find(RatingEntity.class, Query.select().where((String)clause, parameters.toArray()).order("LAST_MODIFICATION DESC").limit(limit).offset(offset));
    }

    public void deleteRatings(Long millisStart, Long millisEnd) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.rating.reset.banner.message"));
        }
        ArrayList<Long> parameters = new ArrayList<Long>();
        Object clause = "";
        if (millisStart != null && millisEnd != null) {
            clause = (String)clause + "LAST_MODIFICATION BETWEEN ? ";
            parameters.add(millisStart);
            clause = (String)clause + "AND ? ";
            parameters.add(millisEnd);
        }
        Query query = Query.select().from(RatingEntity.class).where((String)clause, parameters.toArray());
        BatchHelper.process(this.activeObjects, query, RatingEntity.class, (activeObjects, entities) -> Arrays.stream(entities).forEach(this::deleteRating), 0, false);
    }

    public void exportRatings(long millisStart, long millisEnd, boolean active, OutputStream outputStream) throws IOException {
        String seperator = this.persistenceService.getSettings().getStatisticExportSeperator();
        outputStream.write(this.generateHead(seperator).getBytes());
        this.generateBody(seperator, 0, 500, active, millisStart, millisEnd, outputStream);
    }

    private String generateHead(String seperator) {
        StringBuilder outputResult = new StringBuilder();
        outputResult.append(QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.id")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.categoryId")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.categoryName")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.contentId")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.userKey")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.userName")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.rating")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.active")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.anonymousUser")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-ratings.table.head.rating.lastModification")).append(QUOTE);
        outputResult.append("\n");
        LOGGER.debug(outputResult.toString());
        return outputResult.toString();
    }

    private void generateBody(String seperator, int offset, int limit, boolean active, long millisStart, long millisEnd, OutputStream outputStream) throws IOException {
        RatingEntity[] ratingsResults = this.getRatings(offset, limit, active, millisStart, millisEnd);
        if (ratingsResults.length > 0) {
            StringBuilder outputResultBuilder = new StringBuilder();
            for (RatingEntity ratingEntity : ratingsResults) {
                outputResultBuilder.append(QUOTE).append(ratingEntity.getID()).append(QUOTE);
                CategoryEntity category = ratingEntity.getCategory();
                if (category != null) {
                    outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.getCategory().getID()).append(QUOTE);
                    outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.getCategory().getCategoryName()).append(QUOTE);
                } else {
                    outputResultBuilder.append(seperator + QUOTE).append(QUOTE);
                    outputResultBuilder.append(seperator + QUOTE).append(QUOTE);
                }
                outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.getContentId()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.getUserKey()).append(QUOTE);
                UserKey userKey = new UserKey(ratingEntity.getUserKey());
                UserProfile profile = this.userManager.getUserProfile(userKey);
                String username = profile == null ? "Anonymous" : profile.getUsername();
                outputResultBuilder.append(seperator + QUOTE).append(username).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.getRating()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.isActive()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(ratingEntity.isAnonymousUser()).append(QUOTE);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                long milliSeconds = ratingEntity.getLastModification();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(milliSeconds);
                outputResultBuilder.append(seperator + QUOTE).append(formatter.format(calendar.getTime())).append(QUOTE);
                outputResultBuilder.append("\n");
            }
            outputStream.write(outputResultBuilder.toString().getBytes());
            this.generateBody(seperator, offset + limit, limit, active, millisStart, millisEnd, outputStream);
        }
    }

    private RatingEntity addUserRating(ContentEntityObject contentEntityObject, CategoryEntity category, int userRatingValue) {
        long contentId = contentEntityObject.getId();
        Settings settings = this.persistenceService.getSettings();
        if (category != null) {
            int categoryId = category.getID();
            if (!RatingUserHelper.isAnonymous() && this.persistenceService.getSettings().isLikeCategory(categoryId) && userRatingValue > 0) {
                this.likeManager.addLike(contentEntityObject, (User)AuthenticatedUserThreadLocal.get());
            }
        }
        return (RatingEntity)this.activeObjects.executeInTransaction(() -> {
            RatingEntity ratingEntity = (RatingEntity)this.activeObjects.create(RatingEntity.class, new DBParam[]{new DBParam("CONTENT_ID", (Object)contentId), new DBParam("RATING", (Object)(userRatingValue % 101)), new DBParam("USER_KEY", (Object)RatingUserHelper.getCurrentUserKey(settings)), new DBParam("ANONYMOUS_USER", (Object)(settings.isAnonymousRatingForLoggedInUser() || RatingUserHelper.isAnonymous() ? 1 : 0)), new DBParam("LAST_MODIFICATION", (Object)System.currentTimeMillis()), new DBParam("ACTIVE", (Object)true)});
            ratingEntity.setCriterion(category);
            ratingEntity.save();
            return ratingEntity;
        });
    }

    private boolean isMultiple() {
        Settings settings = this.persistenceService.getSettings();
        return settings != null ? settings.isMultiple() : true;
    }

    private void deactivateRatings(ContentEntityObject contentEntityObject, List<Integer> categoryIds, boolean onlyUser, boolean deactivateLikes) {
        RatingEntity[] ratings = this.getRatings(contentEntityObject.getId(), categoryIds, onlyUser, !deactivateLikes);
        if (deactivateLikes) {
            if (onlyUser) {
                if (!AuthenticatedUserThreadLocal.isAnonymousUser()) {
                    this.likeManager.removeLike(contentEntityObject, (User)AuthenticatedUserThreadLocal.get());
                }
            } else {
                this.likeManager.removeAllLikesOn(contentEntityObject);
            }
        } else {
            Settings settings = this.persistenceService.getSettings();
            ratings = (RatingEntity[])Arrays.stream(ratings).filter(ratingEntity -> !settings.isLikeCategory(ratingEntity.getCategory().getID())).toArray(RatingEntity[]::new);
        }
        if (ratings.length > 0) {
            RatingEntity[] finalRatings = ratings;
            this.activeObjects.executeInTransaction(() -> {
                for (RatingEntity rating : finalRatings) {
                    rating.setActive(false);
                    rating.save();
                    LOGGER.debug("Rating deactivated: {}", (Object)rating.getID());
                }
                return null;
            });
        }
    }

    public void resetContentStatistic(ContentEntityObject contentEntityObject, List<Integer> categoryIds) {
        this.deactivateRatings(contentEntityObject, categoryIds, false, this.persistenceService.getSettings().isRemoveLikesOnResetStatistic());
        this.invalidateCaches(contentEntityObject.getId());
        this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
    }

    public Rating rate(ContentEntityObject contentEntityObject, int categoryId, int rating) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.rating.add.banner.message"));
        }
        Settings settings = this.persistenceService.getSettings();
        if (settings == null) {
            LOGGER.warn("Settings are not available");
            return null;
        }
        if (contentEntityObject == null) {
            LOGGER.warn("Content does not exist");
            return null;
        }
        if (!settings.getFeedbackCollectorType().equals((Object)Settings.FeedbackCollectorType.FEEDBACKMANAGEMENT) && categoryId == 0) {
            LOGGER.warn("User {} tried to access a non-existent category id {}", (Object)AuthenticatedUserThreadLocal.getUsername(), (Object)0);
            return null;
        }
        CategoryEntity category = null;
        if (categoryId != 0) {
            category = this.categoryService.getCriterion(categoryId);
            if (category == null) {
                LOGGER.warn("User {} tried to access a non-existent category {}", (Object)AuthenticatedUserThreadLocal.getUsername(), (Object)categoryId);
                return null;
            }
            LOGGER.debug("Category with id {} was found", (Object)category.getID());
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            if (this.isMultiple()) {
                categoryIds.add(categoryId);
            }
            boolean deactivateLikes = !this.isMultiple() || this.persistenceService.getSettings().getLikeCategoryId() == categoryId;
            this.deactivateRatings(contentEntityObject, categoryIds, true, deactivateLikes);
        }
        RatingEntity ratingEntity = this.addUserRating(contentEntityObject, category, rating);
        this.invalidateCaches(contentEntityObject.getId());
        this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
        return this.asRating(ratingEntity);
    }

    public RatingEntity getRatingEntity(int ratingId) {
        return (RatingEntity)this.activeObjects.get(RatingEntity.class, (Object)ratingId);
    }

    public int getUserRatingValue(ContentEntityObject contentEntityObject, int criterionId) {
        if (this.persistenceService.getSettings().isLikeCategory(criterionId)) {
            if (!RatingUserHelper.isAnonymous()) {
                return this.likeManager.hasLike(contentEntityObject, (User)AuthenticatedUserThreadLocal.get()) ? 100 : 0;
            }
            RatingEntity ratingEntity = this.getUserRating(contentEntityObject.getId(), criterionId, true);
            return ratingEntity == null ? 0 : ratingEntity.getRating();
        }
        RatingEntity ratingEntity = this.getUserRating(contentEntityObject.getId(), criterionId, true);
        return ratingEntity != null ? ratingEntity.getRating() : 0;
    }

    public Rating asRating(RatingEntity ratingEntity) {
        if (ratingEntity == null) {
            return null;
        }
        Rating rating = new Rating();
        rating.setContentId(ratingEntity.getContentId());
        rating.setRatingId(ratingEntity.getID());
        int categoryId = 0;
        if (ratingEntity.getCategory() != null) {
            CategoryEntity categoryEntity = ratingEntity.getCategory();
            rating.setCriterionName(categoryEntity.getCategoryName());
            rating.setCriterionIcon(categoryEntity.getFontAwesomeIcon());
            categoryId = categoryEntity.getID();
        }
        rating.setCriterionId(categoryId);
        UserItem userItem = new UserItem();
        userItem.setUserKey(ratingEntity.getUserKey());
        if (!ratingEntity.isAnonymousUser() && ratingEntity.getUserKey() != null) {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(ratingEntity.getUserKey()));
            userItem.setFullName(confluenceUser.getFullName());
            userItem.setUsername(confluenceUser.getName());
            userItem.setCanView(this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)confluenceUser));
        }
        rating.setUserItem(userItem);
        rating.setLastModification(ratingEntity.getLastModification());
        rating.setRatingValue(ratingEntity.getRating());
        return rating;
    }

    public void invalidateCaches() {
        this.userCountCache.removeAll();
        this.averageCache.removeAll();
        this.categoryCountCache.removeAll();
        this.ratingItemCache.removeAll();
    }

    private void invalidateCaches(long contentId) {
        this.userCountCache.remove((Object)contentId);
        this.ratingItemCache.remove((Object)contentId);
        this.invalidateCache(contentId, this.categoryCountCache);
        this.invalidateCache(contentId, this.averageCache);
    }

    private void invalidateCache(long contentId, Cache<String, ?> cache) {
        List<String> matchingKeys = RatingService.getMatchingKeys(contentId + "_", cache.getKeys());
        for (String matchingKey : matchingKeys) {
            cache.remove((Object)matchingKey);
        }
    }

    private static List<String> getMatchingKeys(String prefix, Collection<String> keys2) {
        ArrayList<String> matchingKeys = new ArrayList<String>();
        if (keys2 != null && keys2.size() > 0) {
            for (String key : keys2) {
                if (!key.startsWith(prefix)) continue;
                matchingKeys.add(key);
            }
        }
        return matchingKeys;
    }

    public int getUserRatingsCount(long contentId) {
        Integer userRatingsCount = (Integer)this.userCountCache.get((Object)contentId);
        return userRatingsCount != null ? userRatingsCount : 0;
    }

    public int getCategoryRatingsCount(long contentId, long categoryId) {
        Integer categoryCount = (Integer)this.categoryCountCache.get((Object)(contentId + "_" + categoryId));
        return categoryCount != null ? categoryCount : 0;
    }

    public double getRatingAverage(long contentId, long categoryId) {
        Double average = (Double)this.averageCache.get((Object)(contentId + "_" + categoryId));
        return average != null ? average : 0.0;
    }

    public RatingItem getRatingItem(Long contentId) {
        return (RatingItem)this.ratingItemCache.get((Object)contentId);
    }

    private class RatingItemCacheLoader
    implements CacheLoader<Long, RatingItem> {
        private RatingItemCacheLoader() {
        }

        @Nonnull
        public RatingItem load(@Nonnull Long contentId) {
            int userCount = RatingService.this.getUserRatingsCount(contentId);
            List<CategoryEntity> categories = RatingService.this.categoryService.getCategories(true);
            RatingItem ratingItem = new RatingItem(contentId, userCount);
            for (CategoryEntity category : categories) {
                int categoryId = category.getID();
                int ratingCount = RatingService.this.getCategoryRatingsCount(contentId, categoryId);
                double averageRating = RatingService.this.getRatingAverage(contentId, categoryId);
                ratingItem.addCategoryItem(categoryId, ratingCount, averageRating);
            }
            return ratingItem;
        }
    }

    private class AverageCacheLoader
    implements CacheLoader<String, Double> {
        AverageCacheLoader() {
        }

        @Nonnull
        public Double load(@Nonnull String identifier) {
            String[] partials = identifier.split("_");
            long contentId = Long.parseLong(partials[0]);
            int categoryId = Integer.parseInt(partials[1]);
            Settings settings = RatingService.this.persistenceService.getSettings();
            int count = RatingService.this.getCategoryRatingsCount(contentId, categoryId);
            if (count == 0) {
                return 0.0;
            }
            if (settings != null && settings.isLikeCategory(categoryId)) {
                return 100.0;
            }
            ArrayList<Integer> criterionIdAsList = new ArrayList<Integer>();
            criterionIdAsList.add(categoryId);
            RatingEntity[] ratingEntities = RatingService.this.getRatings(contentId, criterionIdAsList, false, true);
            double sum = Arrays.stream(ratingEntities).map(RatingEntity::getRating).reduce(0, Integer::sum).intValue();
            return sum / (double)count;
        }
    }

    private class UserCountCacheLoader
    implements CacheLoader<Long, Integer> {
        UserCountCacheLoader() {
        }

        @Nonnull
        public Integer load(@Nonnull Long contentId) {
            ContentEntityObject contentEntityObject;
            List likes;
            HashSet<String> usernames = new HashSet<String>();
            RatingEntity[] ratings = RatingService.this.getRatings(contentId, new ArrayList<Integer>(), false, true);
            Settings settings = RatingService.this.persistenceService.getSettings();
            if (settings != null && settings.hasLikeCategory() && (likes = RatingService.this.likeManager.getLikes(contentEntityObject = RatingService.this.pageManager.getById(contentId.longValue()))) != null) {
                for (Like like : likes) {
                    usernames.add(like.getUsername());
                }
            }
            for (RatingEntity rating : ratings) {
                if (rating.getRating() <= 0) continue;
                usernames.add(rating.getUserKey());
            }
            return usernames.size();
        }
    }

    private class CategoryCountCacheLoader
    implements CacheLoader<String, Integer> {
        CategoryCountCacheLoader() {
        }

        @Nonnull
        public Integer load(@Nonnull String identifier) {
            List likes;
            String[] partials = identifier.split("_");
            long contentId = Long.parseLong(partials[0]);
            int categoryId = Integer.parseInt(partials[1]);
            Settings settings = RatingService.this.persistenceService.getSettings();
            ArrayList<Integer> criterionIdAsList = new ArrayList<Integer>();
            criterionIdAsList.add(categoryId);
            int count = RatingService.this.getRatings(contentId, criterionIdAsList, false, true).length;
            if (settings != null && settings.isLikeCategory(categoryId) && (likes = RatingService.this.likeManager.getLikes(RatingService.this.pageManager.getById(contentId))) != null) {
                count += likes.size();
            }
            return count;
        }
    }
}

