/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.service;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.sal.api.message.I18nResolver;
import io.moewe.confluence.addons.rate.bandana.RateBandanaManager;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class PersistenceService {
    private final RateBandanaManager rateBandanaManager;
    private final I18nResolver i18nResolver;
    private final AccessModeService accessModeService;
    private static final String SETTINGS_KEY = "settings";

    @Inject
    public PersistenceService(RateBandanaManager rateBandanaManager, I18nResolver i18nResolver, AccessModeService accessModeService) {
        this.rateBandanaManager = rateBandanaManager;
        this.i18nResolver = i18nResolver;
        this.accessModeService = accessModeService;
    }

    public void setSettings(Settings settings) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.settings.save.banner.message"));
        }
        this.rateBandanaManager.setValue(SETTINGS_KEY, settings);
    }

    public Settings getSettings() {
        Settings value = this.rateBandanaManager.getValue(SETTINGS_KEY, Settings.class);
        return value;
    }

    public boolean showAverage() {
        Settings.Mode mode = this.getSettings().getMode();
        return Settings.Mode.KNOB.equals((Object)mode);
    }
}

