/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import io.moewe.atlassian.sdk.internal.util.BatchHelper;
import io.moewe.confluence.addons.rate.ao.FeedbackEntity;
import io.moewe.confluence.addons.rate.ao.RatingEntity;
import io.moewe.confluence.addons.rate.rest.pojo.FeedbackItem;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.RatingService;
import io.moewe.confluence.addons.rate.util.RatingUserHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class FeedbackService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackService.class);
    public static final int FEEDBACK_MESSAGE_MAX_SIZE = 450;
    private static final String I18N_TABLE_HEAD_PREFIX = "io.moewe.confluence.addons.rate.export-feedback.table.head.";
    private static final String QUOTE = "\"";
    private static final int DEFAULT_OFFSET = 0;
    private final RatingService ratingService;
    private final ActiveObjects activeObjects;
    private final PageManager pageManager;
    private final ConfluenceIndexer confluenceIndexer;
    private final UserAccessor userAccessor;
    private final TimeZoneManager timeZoneManager;
    private final BootstrapManager bootstrapManager;
    private final FormatSettingsManager formatSettingsManager;
    private final PersistenceService persistenceService;
    private LocaleManager localeManager;
    private DateFormatter dateFormatter;
    private final I18nResolver i18nResolver;
    private final AccessModeService accessModeService;

    @Inject
    public FeedbackService(RatingService ratingService, PersistenceService persistenceService, @ComponentImport ActiveObjects activeObjects, @ComponentImport PageManager pageManager, @ComponentImport @Qualifier(value="confluenceIndexer") ConfluenceIndexer confluenceIndexer, @ComponentImport UserAccessor userAccessor, @ComponentImport TimeZoneManager timeZoneManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport I18nResolver i18nResolver, AccessModeService accessModeService) {
        this.ratingService = ratingService;
        this.activeObjects = activeObjects;
        this.pageManager = pageManager;
        this.confluenceIndexer = confluenceIndexer;
        this.userAccessor = userAccessor;
        this.timeZoneManager = timeZoneManager;
        this.bootstrapManager = bootstrapManager;
        this.formatSettingsManager = formatSettingsManager;
        this.persistenceService = persistenceService;
        this.i18nResolver = i18nResolver;
        this.accessModeService = accessModeService;
    }

    public LocaleManager getLocaleManager() {
        if (this.localeManager == null) {
            this.localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        }
        return this.localeManager;
    }

    public TimeZone getTimeZone() {
        if (this.bootstrapManager.isSetupComplete() && AuthenticatedUserThreadLocal.get() != null) {
            return this.userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get()).getTimeZone();
        }
        return TimeZone.getInstance((String)this.timeZoneManager.getDefaultTimeZone().getID());
    }

    public DateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new DateFormatter(this.getTimeZone(), this.formatSettingsManager, this.getLocaleManager());
        }
        return this.dateFormatter;
    }

    public FeedbackItem addFeedback(int ratingId, String feedbackMessage) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.feedback.add.banner.message"));
        }
        RatingEntity ratingEntity = this.ratingService.getRatingEntity(ratingId);
        if (ratingEntity == null) {
            LOGGER.warn("Rating with id {} was not found.", (Object)ratingId);
            return null;
        }
        if (feedbackMessage.length() > 450) {
            feedbackMessage = feedbackMessage.substring(0, 450);
        }
        String finalFeedbackMessage = feedbackMessage;
        FeedbackEntity feedback = (FeedbackEntity)this.activeObjects.executeInTransaction(() -> {
            FeedbackEntity feedbackEntity = (FeedbackEntity)this.activeObjects.create(FeedbackEntity.class, new DBParam[]{new DBParam("READ", (Object)false), new DBParam("ARCHIVED", (Object)false), new DBParam("MESSAGE", (Object)finalFeedbackMessage), new DBParam("CREATED", (Object)System.currentTimeMillis()), new DBParam("MODIFIED", (Object)System.currentTimeMillis())});
            feedbackEntity.setRating(ratingEntity);
            feedbackEntity.save();
            ContentEntityObject contentEntityObject = this.pageManager.getById(ratingEntity.getContentId());
            if (contentEntityObject == null) {
                LOGGER.warn("User {} tried to access a non-existent content {}", (Object)RatingUserHelper.getCurrentUserKey(this.persistenceService.getSettings()), (Object)ratingEntity.getContentId());
                return null;
            }
            this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
            return feedbackEntity;
        });
        return this.asFeedbackItem(feedback);
    }

    public FeedbackItem getFeedback(int feedbackId) {
        FeedbackEntity feedbackEntity = (FeedbackEntity)this.activeObjects.get(FeedbackEntity.class, (Object)feedbackId);
        return this.asFeedbackItem(feedbackEntity);
    }

    public void deleteFeedback(int feedbackId) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.feedback.delete.banner.message"));
        }
        this.activeObjects.executeInTransaction(() -> {
            FeedbackEntity feedbackEntity = (FeedbackEntity)this.activeObjects.get(FeedbackEntity.class, (Object)feedbackId);
            if (feedbackEntity == null) {
                return null;
            }
            long contentId = feedbackEntity.getRating().getContentId();
            this.activeObjects.delete(new RawEntity[]{feedbackEntity});
            ContentEntityObject contentEntityObject = this.pageManager.getById(contentId);
            if (contentEntityObject == null) {
                return null;
            }
            this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
            return null;
        });
        LOGGER.debug("Feedback deleted: {}", (Object)feedbackId);
    }

    public int getUnreadFeedbackCount(long contentId) {
        FeedbackEntity[] feedbackEntities = (FeedbackEntity[])this.activeObjects.find(FeedbackEntity.class, Query.select().from(FeedbackEntity.class).join(RatingEntity.class, "RATINGID=RE.ID").alias(FeedbackEntity.class, "FE").alias(RatingEntity.class, "RE").where("RE.CONTENT_ID = ? AND READ = ?", new Object[]{contentId, Boolean.FALSE}));
        return feedbackEntities.length;
    }

    public int getOpenFeedbackCount(long contentId) {
        FeedbackEntity[] feedbackEntities = (FeedbackEntity[])this.activeObjects.find(FeedbackEntity.class, Query.select().from(FeedbackEntity.class).join(RatingEntity.class, "RATINGID=RE.ID").alias(FeedbackEntity.class, "FE").alias(RatingEntity.class, "RE").where("RE.CONTENT_ID = ? AND ARCHIVED = ?", new Object[]{contentId, Boolean.FALSE}));
        return feedbackEntities.length;
    }

    public long getLastFeedbackCreated(long contentId) {
        FeedbackEntity[] feedbackEntities = (FeedbackEntity[])this.activeObjects.find(FeedbackEntity.class, Query.select().from(FeedbackEntity.class).join(RatingEntity.class, "RATINGID=RE.ID").alias(FeedbackEntity.class, "FE").alias(RatingEntity.class, "RE").where("RE.CONTENT_ID = ?", new Object[]{contentId}).order("CREATED DESC").limit(1));
        return feedbackEntities.length == 0 ? 0L : feedbackEntities[0].getCreated();
    }

    public FeedbackItem[] getContentFeedback(long contentId) {
        FeedbackEntity[] feedbackEntities = (FeedbackEntity[])this.activeObjects.find(FeedbackEntity.class, Query.select().from(FeedbackEntity.class).join(RatingEntity.class, "RATINGID=RE.ID").alias(FeedbackEntity.class, "FE").alias(RatingEntity.class, "RE").where("RE.CONTENT_ID = ?", new Object[]{contentId}).order("CREATED DESC"));
        return (FeedbackItem[])Arrays.stream(feedbackEntities).map(this::asFeedbackItem).toArray(FeedbackItem[]::new);
    }

    public FeedbackItem modifyFeedback(int id, String feedbackMessage, boolean read, boolean archived) {
        String finalFeedbackMessage;
        FeedbackEntity modifiedFeedback;
        ContentEntityObject contentEntityObject;
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.feedback.modify.banner.message"));
        }
        if (feedbackMessage.length() > 450) {
            feedbackMessage = feedbackMessage.substring(0, 450);
        }
        if ((contentEntityObject = this.pageManager.getById((modifiedFeedback = (FeedbackEntity)this.activeObjects.executeInTransaction(() -> this.lambda$modifyFeedback$3(id, archived, read, finalFeedbackMessage = feedbackMessage))).getRating().getContentId())) != null) {
            this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
        }
        return this.asFeedbackItem(modifiedFeedback);
    }

    private FeedbackItem asFeedbackItem(FeedbackEntity feedbackEntity) {
        if (feedbackEntity == null) {
            return null;
        }
        FeedbackItem feedbackItem = new FeedbackItem();
        feedbackItem.setMessage(feedbackEntity.getMessage());
        feedbackItem.setId(feedbackEntity.getID());
        feedbackItem.setRead(feedbackEntity.isRead());
        feedbackItem.setArchived(feedbackEntity.isArchived());
        feedbackItem.setFormattedDate(this.getDateFormatter().formatDateTime(new Date(feedbackEntity.getCreated())));
        RatingEntity ratingEntity = feedbackEntity.getRating();
        if (ratingEntity != null) {
            feedbackItem.setRating(this.ratingService.asRating(ratingEntity));
        }
        return feedbackItem;
    }

    public FeedbackEntity[] getFeedbacks(int offset, int limit, Long millisStart, Long millisEnd) {
        ArrayList<Long> parameters = new ArrayList<Long>();
        Object clause = "";
        if (millisStart != null && millisEnd != null) {
            clause = (String)clause + "CREATED BETWEEN ?";
            parameters.add(millisStart);
            clause = (String)clause + " AND ? ";
            parameters.add(millisEnd);
        }
        return (FeedbackEntity[])this.activeObjects.find(FeedbackEntity.class, Query.select().where((String)clause, parameters.toArray()).order("CREATED DESC").limit(limit).offset(offset));
    }

    public void deleteFeedbacks(Long millisStart, Long millisEnd) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.feedback.reset.banner.message"));
        }
        ArrayList<Long> parameters = new ArrayList<Long>();
        Object clause = "";
        if (millisStart != null && millisEnd != null) {
            clause = (String)clause + "CREATED BETWEEN ? ";
            parameters.add(millisStart);
            clause = (String)clause + "AND ? ";
            parameters.add(millisEnd);
        }
        Query query = Query.select().from(FeedbackEntity.class).where((String)clause, parameters.toArray());
        BatchHelper.process(this.activeObjects, query, FeedbackEntity.class, (activeObjects, entities) -> {
            for (FeedbackEntity feedbackEntity : entities) {
                this.deleteFeedback(feedbackEntity.getID());
            }
        }, 0, false);
    }

    public void exportFeedback(long millisStart, long millisEnd, OutputStream outputStream) throws IOException {
        String seperator = this.persistenceService.getSettings().getStatisticExportSeperator();
        outputStream.write(this.generateHead(seperator).getBytes());
        this.generateBody(seperator, 0, 500, millisStart, millisEnd, outputStream);
    }

    private String generateHead(String seperator) {
        StringBuilder outputResult = new StringBuilder();
        outputResult.append(QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.id")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.message")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.ratingID")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.ratingName")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.read")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.archived")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.creation")).append(QUOTE);
        outputResult.append(seperator + QUOTE).append(this.i18nResolver.getText("io.moewe.confluence.addons.rate.export-feedback.table.head.feedback.lastModification")).append(QUOTE);
        outputResult.append("\n");
        LOGGER.debug(outputResult.toString());
        return outputResult.toString();
    }

    private void generateBody(String seperator, int offset, int limit, long millisStart, long millisEnd, OutputStream outputStream) throws IOException {
        FeedbackEntity[] feedbackEntities = this.getFeedbacks(offset, limit, millisStart, millisEnd);
        if (feedbackEntities.length > 0) {
            StringBuilder outputResultBuilder = new StringBuilder();
            for (FeedbackEntity feedbackEntity : feedbackEntities) {
                outputResultBuilder.append(QUOTE).append(feedbackEntity.getID()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(feedbackEntity.getMessage()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(feedbackEntity.getRating().getID()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(feedbackEntity.getRating().getCategory().getCategoryName()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(feedbackEntity.isArchived()).append(QUOTE);
                outputResultBuilder.append(seperator + QUOTE).append(feedbackEntity.isRead()).append(QUOTE);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                long milliSecondsCreated = feedbackEntity.getCreated();
                Calendar calendarCreated = Calendar.getInstance();
                calendarCreated.setTimeInMillis(milliSecondsCreated);
                outputResultBuilder.append(seperator + QUOTE).append(formatter.format(calendarCreated.getTime())).append(QUOTE);
                long milliSecondsModified = feedbackEntity.getModified();
                Calendar calendarModified = Calendar.getInstance();
                calendarModified.setTimeInMillis(milliSecondsModified);
                outputResultBuilder.append(seperator + QUOTE).append(formatter.format(calendarModified.getTime())).append(QUOTE);
                outputResultBuilder.append("\n");
            }
            outputStream.write(outputResultBuilder.toString().getBytes());
            this.generateBody(seperator, offset + limit, limit, millisStart, millisEnd, outputStream);
        }
    }

    private /* synthetic */ FeedbackEntity lambda$modifyFeedback$3(int id, boolean archived, boolean read, String finalFeedbackMessage) {
        FeedbackEntity feedbackEntity = (FeedbackEntity)this.activeObjects.get(FeedbackEntity.class, (Object)id);
        feedbackEntity.setRead(archived || read);
        feedbackEntity.setArchived(archived);
        feedbackEntity.setMessage(finalFeedbackMessage);
        feedbackEntity.setModified(System.currentTimeMillis());
        feedbackEntity.save();
        return feedbackEntity;
    }
}

