/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import io.moewe.atlassian.sdk.internal.util.BatchHelper;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.ao.FeedbackEntity;
import io.moewe.confluence.addons.rate.ao.RatingEntity;
import io.moewe.confluence.addons.rate.functions.ContentLabelFilterPredicate;
import io.moewe.confluence.addons.rate.functions.SpaceLabelFilterPredicate;
import io.moewe.confluence.addons.rate.rest.pojo.Criterion;
import io.moewe.confluence.addons.rate.service.ConfluenceServices;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
public class CategoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryService.class);
    private static final int DEFAULT_OFFSET = 0;
    private final UserManager userManager;
    private final AccessModeService accessModeService;
    private final I18nResolver i18nResolver;
    private final PageManager pageManager;
    private final ConfluenceIndexer confluenceIndexer;
    private final ConfluenceServices confluence;

    @Inject
    public CategoryService(@ComponentImport UserManager userManager, @ComponentImport PageManager pageManager, @ComponentImport @Qualifier(value="confluenceIndexer") ConfluenceIndexer confluenceIndexer, AccessModeService accessModeService, I18nResolver i18nResolver, ConfluenceServices confluenceServices) {
        this.userManager = userManager;
        this.accessModeService = accessModeService;
        this.i18nResolver = i18nResolver;
        this.pageManager = pageManager;
        this.confluenceIndexer = confluenceIndexer;
        this.confluence = confluenceServices;
    }

    public List<CategoryEntity> getCategories(boolean onlyActive) {
        return this.getCategories(onlyActive, null);
    }

    public List<CategoryEntity> getCategories(boolean onlyActive, Long contentEntityId) {
        this.checkForUpdates();
        Query query = Query.select().order("CATEGORY_NAME");
        if (onlyActive) {
            query = query.where("ENABLED = ?", new Object[]{Boolean.TRUE});
        }
        List<CategoryEntity> categories = Arrays.asList((CategoryEntity[])this.confluence.getActiveObjects().find(CategoryEntity.class, query));
        categories = this.filterContentAndSpaceLabels(contentEntityId, categories);
        categories.sort((category1, category2) -> {
            if (category1 == null || category2 == null) {
                return 0;
            }
            if (category1.getOrder() == category2.getOrder()) {
                return category1.getCategoryName().compareToIgnoreCase(category2.getCategoryName());
            }
            return category1.getOrder() - category2.getOrder();
        });
        return categories;
    }

    public CategoryEntity getCriterion(long categoryId) {
        Query query = Query.select().where("ID = ?", new Object[]{categoryId});
        CategoryEntity[] categories = (CategoryEntity[])this.confluence.getActiveObjects().find(CategoryEntity.class, query);
        return categories.length == 0 ? null : categories[0];
    }

    public void deleteCategory(int categoryId) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.category.delete.banner.message"));
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to delete a category without the needed permission.", (Object)confluenceUser.getName());
            return;
        }
        Query ratingQuery = Query.select().from(RatingEntity.class).where("CATEGORYID = ?", new Object[]{categoryId});
        BatchHelper.processEach(this.confluence.getActiveObjects(), ratingQuery, RatingEntity.class, (activeObjects, ratingEntity) -> {
            Query feedbackQuery = Query.select().where("RATINGID = ?", new Object[]{ratingEntity.getID()});
            BatchHelper.process(activeObjects, feedbackQuery, FeedbackEntity.class, ActiveObjects::delete, 0, false);
            long contentId = ratingEntity.getContentId();
            activeObjects.delete(new RawEntity[]{ratingEntity});
            ContentEntityObject contentEntityObject = this.pageManager.getById(contentId);
            if (contentEntityObject != null) {
                this.confluenceIndexer.reIndex((Searchable)contentEntityObject);
            }
        }, 0, false);
        this.confluence.getActiveObjects().deleteWithSQL(CategoryEntity.class, "ID = ?", new Object[]{categoryId});
        LOGGER.debug("Category deleted: {}", (Object)categoryId);
    }

    @Transactional
    public int addCategory(Criterion criterion) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.category.add.banner.message"));
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return -1;
        }
        if (criterion.getName() == null || criterion.getName().trim().length() == 0) {
            LOGGER.warn("Name may not be empty.");
            return -2;
        }
        CategoryEntity categoryDB = (CategoryEntity)this.confluence.getActiveObjects().create(CategoryEntity.class, new DBParam[]{new DBParam("CATEGORY_NAME", (Object)criterion.getName()), new DBParam("DESCRIPTION", (Object)criterion.getDescription()), new DBParam("ORDER", (Object)criterion.getOrder()), new DBParam("FONT_AWESOME_ICON", (Object)criterion.getFontawesome()), new DBParam("ENABLED", (Object)criterion.isEnabled()), new DBParam("CONTENT_LABEL_FILTER", (Object)criterion.getContentLabelFilter()), new DBParam("SPACE_LABEL_FILTER", (Object)criterion.getSpaceLabelFilter())});
        LOGGER.debug("Category created: {}", (Object)categoryDB.getID());
        return categoryDB.getID();
    }

    @Transactional
    public int updateCategory(Criterion criterion) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18nResolver.getText("io.moewe.confluence.addons.rate.read.only.mode.category.update.banner.message"));
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.userManager.isAdmin(confluenceUser.getKey())) {
            LOGGER.warn("User {} tried to create a category without the needed permission.", (Object)confluenceUser.getName());
            return -1;
        }
        if (criterion.getName() == null || criterion.getName().trim().length() == 0) {
            LOGGER.warn("Name may not be empty.");
            return -2;
        }
        CategoryEntity category = this.getCriterion(criterion.getId());
        if (category == null) {
            LOGGER.warn("There was no category for id {}", (Object)criterion.getId());
            return -3;
        }
        category.setCategoryName(criterion.getName());
        category.setDescription(criterion.getDescription());
        category.setOrder(criterion.getOrder());
        category.setFontAwesomeIcon(criterion.getFontawesome());
        category.setEnabled(criterion.isEnabled());
        category.setContentLabelFilter(criterion.getContentLabelFilter());
        category.setSpaceLabelFilter(criterion.getSpaceLabelFilter());
        category.save();
        LOGGER.debug("Category updated: {}", (Object)category.getID());
        return category.getID();
    }

    private List<CategoryEntity> filterContentAndSpaceLabels(Long contentEntityId, List<CategoryEntity> categories) {
        ContentEntityObject contentEntityObject;
        if (contentEntityId == null || (contentEntityObject = this.pageManager.getById(contentEntityId.longValue())) == null) {
            return categories;
        }
        categories = categories.stream().filter(new ContentLabelFilterPredicate(contentEntityObject)).collect(Collectors.toList());
        if (contentEntityObject instanceof SpaceContentEntityObject) {
            categories = categories.stream().filter(new SpaceLabelFilterPredicate((SpaceContentEntityObject)contentEntityObject)).collect(Collectors.toList());
        }
        return categories;
    }

    private void checkForUpdates() {
        if (this.confluence.getBandanaManager().getValue((BandanaContext)new ConfluenceBandanaContext(), "moewe.rate-add-on.default-data-inserted") != null) {
            LOGGER.debug("Skipping update, as it is already applied.");
            return;
        }
        LOGGER.debug("Inserting default values.");
        this.confluence.getActiveObjects().find(CategoryEntity.class);
        HashMap<String, String[]> defaultCategories = new HashMap<String, String[]>();
        defaultCategories.put("Perspicuity", new String[]{"How perspicacious is this content?", "fas fa-user"});
        defaultCategories.put("Structure", new String[]{"How well structured is this content?", "fas fa-cubes"});
        defaultCategories.put("Significance", new String[]{"How significant is this content?", "far fa-lightbulb"});
        for (Map.Entry defaultContent : defaultCategories.entrySet()) {
            CategoryEntity category = (CategoryEntity)this.confluence.getActiveObjects().create(CategoryEntity.class, new DBParam[]{new DBParam("CATEGORY_NAME", defaultContent.getKey()), new DBParam("DESCRIPTION", (Object)((String[])defaultContent.getValue())[0]), new DBParam("ORDER", (Object)0), new DBParam("FONT_AWESOME_ICON", (Object)((String[])defaultContent.getValue())[1]), new DBParam("ENABLED", (Object)true)});
            category.save();
        }
        this.confluence.getBandanaManager().setValue((BandanaContext)new ConfluenceBandanaContext(), "moewe.rate-add-on.default-data-inserted", (Object)true);
    }
}

