/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.search;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.FeedbackService;
import io.moewe.confluence.addons.rate.service.RatingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@ExportAsService
public class RatingExtractor
implements Extractor2 {
    private final RatingService ratingService;
    private final CategoryService categoryService;
    private final FeedbackService feedbackService;

    @Inject
    public RatingExtractor(RatingService ratingService, CategoryService categoryService, FeedbackService feedbackService) {
        this.ratingService = ratingService;
        this.categoryService = categoryService;
        this.feedbackService = feedbackService;
    }

    public StringBuilder extractText(Object searchable) {
        return new StringBuilder(0);
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ArrayList<FieldDescriptor> fields2 = new ArrayList<FieldDescriptor>();
        if (!(searchable instanceof ContentEntityObject)) {
            return fields2;
        }
        ContentEntityObject contentEntityObject = (ContentEntityObject)searchable;
        long contentId = contentEntityObject.getId();
        int userCount = this.ratingService.getUserRatingsCount(contentId);
        if (userCount > 0) {
            FieldDescriptor field = new FieldDescriptor("rating.usercount", String.valueOf(userCount), FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
            fields2.add(field);
        }
        fields2.add(new FieldDescriptor("rating.feedback.created", String.valueOf(this.feedbackService.getLastFeedbackCreated(contentId)), FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
        fields2.add(new FieldDescriptor("rating.feedback.open", String.valueOf(this.feedbackService.getOpenFeedbackCount(contentId)), FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
        fields2.add(new FieldDescriptor("rating.feedback.unread", String.valueOf(this.feedbackService.getUnreadFeedbackCount(contentId)), FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
        List<CategoryEntity> categories = this.categoryService.getCategories(true);
        for (CategoryEntity category : categories) {
            double categoryAverage;
            int categoryID = category.getID();
            int categoryCount = this.ratingService.getCategoryRatingsCount(contentId, categoryID);
            if (categoryCount > 0) {
                fields2.add(new FieldDescriptor("rating.cat." + categoryID + ".count", String.valueOf(categoryCount), FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
            }
            if (!((categoryAverage = this.ratingService.getRatingAverage(contentId, categoryID)) > 0.0)) continue;
            fields2.add(new FieldDescriptor("rating.cat." + categoryID + ".average", String.valueOf(categoryAverage), FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
        }
        return fields2;
    }
}

