/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest.pojo;

import com.atlassian.confluence.search.v2.SearchResult;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.rest.pojo.CategoryItem;
import io.moewe.confluence.addons.rate.service.FeedbackService;
import io.moewe.confluence.addons.rate.service.RatingService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class StatisticItem
implements Serializable {
    private Long contentId;
    private String title;
    private String spaceKey;
    private String spaceName;
    private String type;
    private String urlPath;
    private int userCount;
    private long lastFeedback;
    private int openFeedback;
    private int unreadFeedback;
    private final List<CategoryItem> categoryItems = new ArrayList<CategoryItem>();

    public StatisticItem() {
    }

    public StatisticItem(SearchResult searchResult, List<CategoryEntity> categories, RatingService ratingService, FeedbackService feedbackService) {
        this.title = searchResult.getDisplayTitle();
        this.spaceKey = searchResult.getSpaceKey();
        this.spaceName = searchResult.getSpaceName();
        this.type = searchResult.getType();
        this.urlPath = searchResult.getUrlPath();
        this.contentId = searchResult.getHandleId();
        this.userCount = ratingService.getUserRatingsCount(this.contentId);
        this.lastFeedback = feedbackService.getLastFeedbackCreated(this.contentId);
        this.openFeedback = feedbackService.getOpenFeedbackCount(this.contentId);
        this.unreadFeedback = feedbackService.getUnreadFeedbackCount(this.contentId);
        for (CategoryEntity category : categories) {
            int categoryId = category.getID();
            int categoryCount = ratingService.getCategoryRatingsCount(this.contentId, categoryId);
            double categoryAverage = ratingService.getRatingAverage(this.contentId, categoryId);
            this.categoryItems.add(new CategoryItem(categoryId, categoryCount, categoryAverage));
        }
    }

    public List<CategoryItem> getCategoryItems() {
        return this.categoryItems;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public long getLastFeedback() {
        return this.lastFeedback;
    }

    public int getOpenFeedback() {
        return this.openFeedback;
    }

    public int getUnreadFeedback() {
        return this.unreadFeedback;
    }
}

