/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.moewe.confluence.addons.rate.util.SanitizationHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Settings
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    public static final boolean DEFAULT_MULTIPLE = true;
    private static final String DEFAULT_HEADLINE = "What do you think about this content?";
    private static final String SPACE_KEY_SEPERATOR = ",";
    private static final int DEFAULT_LIKE_CATEGORY_ID = -1;
    public static final String DEFAULT_FEEDBACK_DIALOG_HEADLINE = "Any feedback on this?";
    private static final boolean DEFAULT_ANONYMOUS_RATING_LOGGEDIN_USER = false;
    private static final int DEFAULT_ANONYMOUS_SESSION_EXPIRATION = 31536000;
    private long id;
    private String headline;
    private boolean pageEnabled = true;
    private boolean blogpostEnabled = true;
    private boolean multiple = true;
    private boolean hideRatingResultUsers = false;
    private boolean hideResult = false;
    private boolean hideOverall = false;
    private Mode mode = Mode.TOGGLE;
    private SpaceRestriction spaceRestriction = SpaceRestriction.NONE;
    private AnonymousAccess anonymousAccess = AnonymousAccess.NONE;
    private boolean anonymousRatingForLoggedInUser = false;
    private Boolean anonymousLike = false;
    private int anonymousSessionExpiration = 31536000;
    private String[] spaceKeys;
    private String[] contentLabelFilters = new String[0];
    private int likeCategoryId = -1;
    private InsertionPlacement insertionPlacement = InsertionPlacement.AFTER;
    private InsertionType insertionType = InsertionType.CONTENT;
    private String insertionSelector;
    private String insertionStyle;
    private String statisticExportSeperator = ",";
    private String statisticUserGroups;
    private boolean resettableContentStatistic = false;
    private boolean resettableSpaceStatistic = false;
    private boolean feedbackRegardless = true;
    private boolean removeLikesOnResetStatistic = false;
    private boolean statisticUserGroupsCanReset = false;
    private List<Integer> resetCategoryIds = new ArrayList<Integer>();
    private FeedbackCollectorType feedbackCollectorType = FeedbackCollectorType.NONE;
    private String jiraIssueCollectorUrl;
    private String feedbackDialogHeadline = "Any feedback on this?";

    public boolean isFeedbackRegardless() {
        return this.feedbackRegardless;
    }

    public void setFeedbackRegardless(boolean feedbackRegardless) {
        this.feedbackRegardless = feedbackRegardless;
    }

    public String getStatisticExportSeperator() {
        return this.statisticExportSeperator;
    }

    public void setStatisticExportSeperator(String statisticExportSeperator) {
        this.statisticExportSeperator = statisticExportSeperator;
    }

    public boolean isHideRatingResultUsers() {
        return this.hideRatingResultUsers;
    }

    public void setHideRatingResultUsers(boolean hideRatingResultUsers) {
        this.hideRatingResultUsers = hideRatingResultUsers;
    }

    public boolean isHideOverall() {
        return this.hideOverall;
    }

    public void setHideOverall(boolean hideOverall) {
        this.hideOverall = hideOverall;
    }

    public String[] getContentLabelFilters() {
        return this.contentLabelFilters;
    }

    @JsonIgnore
    public String getContentLabelFiltersAsString() {
        return this.contentLabelFilters == null ? "" : String.join((CharSequence)" ", this.contentLabelFilters);
    }

    @XmlElement(name="contentLabelFiltersFromString")
    public void setContentLabelFiltersFromString(String contentLabelFilters) {
        if (contentLabelFilters == null || contentLabelFilters.trim().isEmpty()) {
            return;
        }
        String[] labels = SanitizationHelper.Companion.sanitizeLabels(contentLabelFilters).split("[\\s,]+");
        this.setContentLabelFilters(labels);
    }

    public void setContentLabelFilters(String[] contentLabelFilters) {
        this.contentLabelFilters = contentLabelFilters == null ? new String[]{} : contentLabelFilters;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getHeadline() {
        if (this.headline == null) {
            this.headline = DEFAULT_HEADLINE;
        }
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public boolean isPageEnabled() {
        return this.pageEnabled;
    }

    public void setPageEnabled(Boolean enabled) {
        this.pageEnabled = enabled != null ? enabled : false;
    }

    public boolean isBlogpostEnabled() {
        return this.blogpostEnabled;
    }

    public void setBlogpostEnabled(Boolean enabled) {
        this.blogpostEnabled = enabled != null ? enabled : false;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple != null ? multiple : false;
    }

    public boolean isHideResult() {
        return this.hideResult;
    }

    public void setHideResult(Boolean hideResult) {
        this.hideResult = hideResult != null ? hideResult : false;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public SpaceRestriction getSpaceRestriction() {
        return this.spaceRestriction;
    }

    public void setSpaceRestriction(SpaceRestriction spaceRestriction) {
        this.spaceRestriction = spaceRestriction;
    }

    public AnonymousAccess getAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(AnonymousAccess anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    public boolean hasAnonymousAccess() {
        return !AnonymousAccess.NONE.equals((Object)this.getAnonymousAccess());
    }

    public boolean hasAnonymousAccessAndVote() {
        return AnonymousAccess.VOTE.equals((Object)this.getAnonymousAccess());
    }

    public boolean isAnonymousLike() {
        return this.hasAnonymousAccess() && this.anonymousLike != false;
    }

    public void setAnonymousLike(Boolean anonymousLike) {
        this.anonymousLike = anonymousLike;
    }

    public String[] getSpaceKeys() {
        if (this.spaceKeys == null) {
            return new String[0];
        }
        return this.spaceKeys;
    }

    @JsonIgnore
    public String getSpaceKeysAsString() {
        if (this.spaceKeys == null) {
            return "";
        }
        return StringUtils.join(Arrays.asList(this.spaceKeys), (String)", ");
    }

    public void setSpaceKeys(String[] spaceKeys) {
        this.spaceKeys = (String[])Arrays.stream(spaceKeys).map(String::trim).toArray(String[]::new);
    }

    public int getLikeCategoryId() {
        return this.likeCategoryId;
    }

    public void setLikeCategoryId(int categoryId) {
        this.likeCategoryId = categoryId;
    }

    public boolean hasLikeCategory() {
        return this.getLikeCategoryId() > -1;
    }

    public boolean isLikeCategory(int categoryId) {
        return categoryId == this.getLikeCategoryId();
    }

    public InsertionPlacement getInsertionPlacement() {
        return this.insertionPlacement;
    }

    public void setInsertionPlacement(InsertionPlacement insertionPlacement) {
        this.insertionPlacement = insertionPlacement;
    }

    public InsertionType getInsertionType() {
        return this.insertionType;
    }

    public void setInsertionType(InsertionType insertionType) {
        this.insertionType = insertionType;
    }

    public String getInsertionSelector() {
        if (this.insertionSelector == null) {
            this.insertionSelector = "";
        }
        return this.insertionSelector;
    }

    public void setInsertionSelector(String insertionSelector) {
        this.insertionSelector = insertionSelector;
    }

    public String getInsertionStyle() {
        return this.insertionStyle;
    }

    public void setInsertionStyle(String insertionStyle) {
        if (StringUtils.isNotEmpty((CharSequence)insertionStyle)) {
            insertionStyle = insertionStyle.replaceAll("\\\"", "");
        }
        this.insertionStyle = insertionStyle;
    }

    public boolean isResettableContentStatistic() {
        return this.resettableContentStatistic;
    }

    public void setResettableContentStatistic(Boolean resettableContentStatistic) {
        this.resettableContentStatistic = resettableContentStatistic != null ? resettableContentStatistic : false;
    }

    public boolean isResettableSpaceStatistic() {
        return this.resettableSpaceStatistic;
    }

    public void setResettableSpaceStatistic(Boolean resettableContentStatistic) {
        this.resettableContentStatistic = resettableContentStatistic != null ? resettableContentStatistic : false;
    }

    public boolean isRemoveLikesOnResetStatistic() {
        return this.removeLikesOnResetStatistic;
    }

    public void setRemoveLikesOnResetStatistic(Boolean removeLikesOnResetStatistic) {
        this.removeLikesOnResetStatistic = removeLikesOnResetStatistic != null ? removeLikesOnResetStatistic : false;
    }

    public List<Integer> getResetCategoryIds() {
        if (this.resetCategoryIds == null) {
            this.resetCategoryIds = new ArrayList<Integer>();
        }
        return this.resetCategoryIds;
    }

    public void setResetCategoryIds(List<Integer> resetCategoryIds) {
        this.resetCategoryIds = resetCategoryIds;
    }

    @XmlElement(name="resetCategoryIdsFromString")
    public void setResetCategoryIdsFromString(String categoryIdsAsString) {
        if (categoryIdsAsString == null || categoryIdsAsString.isBlank()) {
            return;
        }
        categoryIdsAsString = categoryIdsAsString.replaceAll("\\s+", "");
        this.resetCategoryIds = Arrays.stream(categoryIdsAsString.split(SPACE_KEY_SEPERATOR)).filter(s -> !s.isBlank()).map(Integer::parseInt).collect(Collectors.toList());
    }

    public String getStatisticUserGroups() {
        return this.statisticUserGroups;
    }

    public void setStatisticUserGroups(String statisticUserGroups) {
        this.statisticUserGroups = statisticUserGroups;
    }

    public boolean isStatisticUserGroupsCanReset() {
        return this.statisticUserGroupsCanReset;
    }

    public void setStatisticUserGroupsCanReset(boolean statisticUserGroupsCanReset) {
        this.statisticUserGroupsCanReset = statisticUserGroupsCanReset;
    }

    public FeedbackCollectorType getFeedbackCollectorType() {
        return this.feedbackCollectorType;
    }

    public void setFeedbackCollectorType(FeedbackCollectorType feedbackCollectorType) {
        this.feedbackCollectorType = feedbackCollectorType;
    }

    public String getJiraIssueCollectorUrl() {
        return this.jiraIssueCollectorUrl == null ? "" : this.jiraIssueCollectorUrl.trim();
    }

    public void setJiraIssueCollectorUrl(String jiraIssueCollectorUrl) {
        this.jiraIssueCollectorUrl = jiraIssueCollectorUrl;
    }

    public String getFeedbackDialogHeadline() {
        return this.feedbackDialogHeadline;
    }

    public void setFeedbackDialogHeadline(String feedbackDialogHeadline) {
        this.feedbackDialogHeadline = feedbackDialogHeadline;
    }

    public boolean isAnonymousRatingForLoggedInUser() {
        return this.anonymousRatingForLoggedInUser;
    }

    public void setAnonymousRatingForLoggedInUser(Boolean anonymousRatingForLoggedInUser) {
        this.anonymousRatingForLoggedInUser = anonymousRatingForLoggedInUser != null ? anonymousRatingForLoggedInUser : false;
    }

    public int getAnonymousSessionExpiration() {
        return this.anonymousSessionExpiration;
    }

    public void setAnonymousSessionExpiration(int anonymousSessionExpiration) {
        this.anonymousSessionExpiration = anonymousSessionExpiration;
    }

    public static enum Mode {
        TOGGLE,
        TOGGLE_SMALL,
        KNOB,
        STARS;


        public static Mode getModeWithFallback(String value) {
            if (value == null || value.isEmpty()) {
                return TOGGLE;
            }
            try {
                return Mode.valueOf(value.trim().toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("Mode value {} not exists.", (Object)value);
                return TOGGLE;
            }
        }
    }

    public static enum SpaceRestriction {
        NONE,
        EXCLUDE,
        INCLUDE;


        public static SpaceRestriction getSpaceRestrictionWithFallback(String value) {
            if (value != null) {
                try {
                    return SpaceRestriction.valueOf(value);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.debug("Space restriction value {} not exists.", (Object)value);
                }
            }
            return NONE;
        }
    }

    public static enum AnonymousAccess {
        NONE,
        VIEW,
        VOTE;


        public static AnonymousAccess getAnonymousAccessWithFallback(String value) {
            try {
                return AnonymousAccess.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Anonymous access value {} not exists.", (Object)value);
                return NONE;
            }
        }
    }

    public static enum InsertionPlacement {
        BEFORE,
        AFTER,
        APPEND,
        PREPEND;


        public static InsertionPlacement getInsertionPlacementWithFallback(String value) {
            try {
                return InsertionPlacement.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Insertion placement value {} not exists.", (Object)value);
                return AFTER;
            }
        }
    }

    public static enum InsertionType {
        CONTENT,
        TITLE,
        CUSTOM;


        public static InsertionType getInsertionTypeWithFallback(String value) {
            try {
                return InsertionType.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Insertion type value {} not exists.", (Object)value);
                return CONTENT;
            }
        }
    }

    public static enum FeedbackCollectorType {
        NONE,
        FEEDBACKMANAGEMENT,
        JIRAISSUECOLLECTOR;


        public static FeedbackCollectorType getFeedbackCollectorWithFallback(String value) {
            try {
                return FeedbackCollectorType.valueOf(value);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Feedback value {} not exists.", (Object)value);
                return NONE;
            }
        }
    }
}

