/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import io.moewe.confluence.addons.rate.service.StatisticResults;
import io.moewe.confluence.addons.rate.service.StatisticService;
import java.util.Arrays;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/statistic")
@Produces(value={"application/json"})
public class StatisticResource {
    private final StatisticService statisticService;

    public StatisticResource(StatisticService statisticService) {
        this.statisticService = statisticService;
    }

    @GET
    @Path(value="/list")
    public Response listStatistic(@QueryParam(value="spaceKeys") String paramSpaceKeys, @QueryParam(value="title") String title, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="order") String order, @QueryParam(value="orderBy") String orderBy) {
        HashSet<String> spaceKeys = new HashSet<String>();
        if (StringUtils.isNotBlank((String)paramSpaceKeys)) {
            paramSpaceKeys = paramSpaceKeys.replace(" ", "");
            spaceKeys = new HashSet<String>(Arrays.asList(paramSpaceKeys.split(",")));
        }
        StatisticResults statisticResults = this.statisticService.getStatisticResults(spaceKeys, title, offset, limit, order, orderBy);
        return Response.ok((Object)statisticResults).build();
    }

    @ReadOnlyAccessAllowed
    @GET
    @Path(value="/reset")
    public Response resetStatistic(@QueryParam(value="spaceKeys") String paramSpaceKeys, @QueryParam(value="title") String title) {
        HashSet<String> spaceKeys = new HashSet<String>();
        if (StringUtils.isNotBlank((String)paramSpaceKeys)) {
            paramSpaceKeys = paramSpaceKeys.replace(" ", "");
            spaceKeys = new HashSet<String>(Arrays.asList(paramSpaceKeys.split(",")));
        }
        this.statisticService.resetStatistic(spaceKeys, title);
        return Response.ok().build();
    }
}

