/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.RatingService;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/settings")
@Produces(value={"application/json"})
public class SettingsResource {
    private final PersistenceService persistenceService;
    private final RatingService ratingService;
    private final GroupManager groupManager;
    private final I18nResolver i18nResolver;
    private final ObjectMapper mapper = new ObjectMapper();

    public SettingsResource(PersistenceService persistenceService, RatingService ratingService, GroupManager groupManager, I18nResolver i18nResolver) {
        this.persistenceService = persistenceService;
        this.ratingService = ratingService;
        this.groupManager = groupManager;
        this.i18nResolver = i18nResolver;
    }

    @GET
    public Response getSettings() {
        Settings settings = this.persistenceService.getSettings();
        if (settings == null) {
            settings = new Settings();
        }
        try {
            return Response.ok((Object)this.mapper.writeValueAsString(settings)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @ReadOnlyAccessAllowed
    @POST
    @Consumes(value={"application/json"})
    public Response setSettings(Settings settings) {
        if (settings != null && StringUtils.isNotBlank((CharSequence)settings.getStatisticUserGroups())) {
            List<String> statisticUserGroups = Arrays.asList(settings.getStatisticUserGroups().split(","));
            for (String statisticUserGroup : statisticUserGroups) {
                try {
                    if (this.groupManager.getGroup(statisticUserGroup.trim()) != null) continue;
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.userGroup.inputField.error") + " " + statisticUserGroup.trim())).build();
                }
                catch (EntityException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.delete-feedback.error")).build();
                }
            }
        }
        this.persistenceService.setSettings(settings);
        this.ratingService.invalidateCaches();
        return this.getSettings();
    }
}

