/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.ao.RatingEntity;
import io.moewe.confluence.addons.rate.rest.pojo.CategoryItem;
import io.moewe.confluence.addons.rate.rest.pojo.CategoryRating;
import io.moewe.confluence.addons.rate.rest.pojo.Rating;
import io.moewe.confluence.addons.rate.rest.pojo.RatingItem;
import io.moewe.confluence.addons.rate.rest.pojo.RatingUserItems;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.rest.pojo.UserItem;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.RatingService;
import io.moewe.confluence.addons.rate.service.StatisticService;
import io.moewe.confluence.addons.rate.util.FontAwesome4to5Helper;
import io.moewe.confluence.addons.rate.util.LimitedSizeListMap;
import io.moewe.confluence.addons.rate.util.RatingUserHelper;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rating")
@Produces(value={"application/json"})
public class RatingResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RatingResource.class);
    private static final String RATING_KEY_ITEMS = "items";
    private static final String RATING_KEY_USER_COUNT = "userCount";
    private static final String RATING_KEY_CURRENT_RATING = "rating";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final int DAY_END_TIME = 86399999;
    public static final int LAST_USER_ITEMS_LIMIT = 10;
    private final CategoryService categoryService;
    private final RatingService ratingService;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final StatisticService statisticService;
    private final PersistenceService persistenceService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    public RatingResource(CategoryService categoryService, RatingService ratingService, StatisticService statisticService, PersistenceService persistenceService, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport UserManager userManager, I18nResolver i18nResolver) {
        this.categoryService = categoryService;
        this.ratingService = ratingService;
        this.statisticService = statisticService;
        this.persistenceService = persistenceService;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @AnonymousAllowed
    @Path(value="/list")
    public Response getRating(@QueryParam(value="contentId") long contentId) {
        ContentEntityObject contentEntityObject = this.pageManager.getById(contentId);
        Response errorResponse = this.getPreconditionErrorResponse(contentEntityObject, false);
        if (errorResponse != null) {
            return errorResponse;
        }
        assert (contentEntityObject != null);
        Map<String, Object> responseMap = this.buildRatingsResponseMap(contentEntityObject, null);
        return Response.ok(responseMap).build();
    }

    @ReadOnlyAccessAllowed
    @POST
    @AnonymousAllowed
    @Path(value="/add")
    @Consumes(value={"application/json"})
    public Response addRating(Rating rating) {
        ContentEntityObject contentEntityObject = this.pageManager.getById(rating.getContentId());
        Response errorResponse = this.getPreconditionErrorResponse(contentEntityObject, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        if (!this.categoryService.getCriterion(rating.getCriterionId()).isEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"{\"error\": \"criterion is disabled\"}").build();
        }
        if (RatingUserHelper.isAnonymous() && this.isLikeCategory(rating.getCriterionId()) && this.anonymousLikeDisabled()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{\"error\": \"anonymous users cannot like\"}").build();
        }
        rating = this.ratingService.rate(contentEntityObject, rating.getCriterionId(), rating.getRatingValue());
        assert (contentEntityObject != null);
        Map<String, Object> responseMap = this.buildRatingsResponseMap(contentEntityObject, rating);
        return Response.ok(responseMap).build();
    }

    @AnonymousAllowed
    @GET
    @Path(value="{contentId}/latestUsers")
    public Response getLatestUsers(@PathParam(value="contentId") long contentId, @QueryParam(value="limit") int limit) {
        if (limit < 0 || limit > 10) {
            limit = 10;
        }
        if (AuthenticatedUserThreadLocal.isAnonymousUser()) {
            return Response.ok(new ArrayList()).build();
        }
        RatingUserItems ratingUserItems = null;
        List<CategoryEntity> criteria = this.categoryService.getCategories(true, contentId);
        for (CategoryEntity criterion : criteria) {
            ArrayList<Rating> ratings = new ArrayList<Rating>();
            if (!this.persistenceService.getSettings().isHideRatingResultUsers()) {
                RatingEntity[] ratingEntities;
                for (RatingEntity ratingEntity : ratingEntities = this.ratingService.getLastRatings(contentId, criterion.getID(), limit)) {
                    Rating rating = this.ratingService.asRating(ratingEntity);
                    if (rating == null) continue;
                    ratings.add(rating);
                }
            }
            LinkedHashMap<Integer, List<Rating>> criteriaLastRatings = this.addCriteriaRatings(criterion.getID(), ratings);
            int totalUserCounts = this.ratingService.getUserRatingsCount(contentId);
            LimitedSizeListMap<Integer, UserItem> criteriaLastUserItems = this.getCriteriaLastUserItems(criteriaLastRatings);
            List<UserItem> lastUserItems = this.getLastUserItems(criteriaLastRatings, limit);
            Map<Integer, Integer> criteriaTotalUserCounts = this.addCount(criterion.getID(), this.ratingService.getCategoryRatingsCount(contentId, criterion.getID()));
            ratingUserItems = new RatingUserItems(totalUserCounts, criteriaLastUserItems, lastUserItems, criteriaTotalUserCounts);
            this.ratingService.getUserRatingsCount(contentId);
        }
        return Response.ok(ratingUserItems).build();
    }

    @ReadOnlyAccessAllowed
    @GET
    @Path(value="/delete")
    public Response resetRatings(@QueryParam(value="start") String start, @QueryParam(value="end") String end) {
        long millisEnd;
        long millisStart;
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            LOGGER.debug("User has no permission to delete.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (start == null || start.isEmpty() || end == null || end.isEmpty()) {
            LOGGER.debug("Startdate or enddate is null or empty.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.empty.error")).build();
        }
        try {
            millisStart = this.convertDate(start);
            millisEnd = this.convertDate(end) + 86399999L;
        }
        catch (ParseException e) {
            String errorFormat = "Startdate or enddate has wrong format.";
            LOGGER.debug(errorFormat);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.format.error")).build();
        }
        this.ratingService.deleteRatings(millisStart, millisEnd);
        return Response.ok().build();
    }

    @GET
    @Path(value="/export")
    public Response exportRatings(@QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="active") boolean active) {
        long millisEnd;
        long millisStart;
        if (!this.statisticService.hasGlobalStatisticPermissions(this.userManager.getRemoteUserKey())) {
            LOGGER.debug("User has no permission to export.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (start == null || start.isEmpty() || end == null || end.isEmpty()) {
            LOGGER.debug("Startdate or enddate is null or empty.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.empty.error")).build();
        }
        try {
            millisStart = this.convertDate(start);
            millisEnd = this.convertDate(end) + 86399999L;
        }
        catch (ParseException e) {
            String errorFormat = "Startdate or enddate has wrong format.";
            LOGGER.debug(errorFormat);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.format.error")).build();
        }
        StreamingOutput fileStream = output -> {
            try {
                this.ratingService.exportRatings(millisStart, millisEnd, active, output);
                output.flush();
            }
            catch (Exception e) {
                LOGGER.error("Exception occurs while exporting.", (Throwable)e);
            }
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)"attachment; filename = export-ratings.csv").build();
    }

    private long convertDate(String dateString) throws ParseException {
        Date date = DATE_FORMAT.parse(dateString);
        return date.getTime();
    }

    public LinkedHashMap<Integer, List<Rating>> addCriteriaRatings(Integer criterionId, List<Rating> ratings) {
        LinkedHashMap<Integer, List<Rating>> criteriaLastRatings = new LinkedHashMap<Integer, List<Rating>>();
        criteriaLastRatings.put(criterionId, ratings);
        return criteriaLastRatings;
    }

    public Map<Integer, Integer> addCount(Integer criterionId, Integer count) {
        HashMap<Integer, Integer> criteriaTotalUserCounts = new HashMap<Integer, Integer>();
        criteriaTotalUserCounts.put(criterionId, count);
        return criteriaTotalUserCounts;
    }

    public LimitedSizeListMap<Integer, UserItem> getCriteriaLastUserItems(LinkedHashMap<Integer, List<Rating>> criteriaLastRatings) {
        LimitedSizeListMap<Integer, UserItem> criteriaLastUserItems = new LimitedSizeListMap<Integer, UserItem>();
        for (Integer criterionId : criteriaLastRatings.keySet()) {
            List<Rating> criterionLastRatings = criteriaLastRatings.get(criterionId);
            for (Rating criterionLastRating : criterionLastRatings) {
                criteriaLastUserItems.append(criterionId, criterionLastRating.getUserItem());
            }
        }
        return criteriaLastUserItems;
    }

    public List<UserItem> getLastUserItems(LinkedHashMap<Integer, List<Rating>> criteriaLastRatings, int limit) {
        ArrayList<UserItem> lastUserItems = new ArrayList<UserItem>();
        int index = 1;
        ArrayList<Rating> criteriaRatings = new ArrayList<Rating>();
        for (List<Rating> list : criteriaLastRatings.values()) {
            criteriaRatings.addAll(list);
        }
        Collections.sort(criteriaRatings);
        for (Rating rating : criteriaRatings) {
            if (lastUserItems.contains(rating.getUserItem())) continue;
            lastUserItems.add(rating.getUserItem());
            if (index == limit) break;
            ++index;
        }
        return lastUserItems;
    }

    private Response getPreconditionErrorResponse(ContentEntityObject contentEntityObject, Boolean isVote) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (contentEntityObject == null) {
            LOGGER.warn("User '{}' tried to access non-existent content", (Object)(confluenceUser == null ? "Anonymous" : confluenceUser.getKey()));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        long contentId = contentEntityObject.getId();
        if (confluenceUser == null) {
            Settings settings = this.persistenceService.getSettings();
            if (!settings.hasAnonymousAccess()) {
                LOGGER.warn("Anonymous user is not allowed to access content ratings");
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            if (isVote.booleanValue() && !settings.hasAnonymousAccessAndVote()) {
                LOGGER.warn("Anonymous user is not allowed to vote content {}", (Object)contentId);
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
        }
        if (!this.permissionManager.hasPermission((User)confluenceUser, Permission.VIEW, (Object)contentEntityObject)) {
            LOGGER.warn("User '{}' is not allowed to access content {}", (Object)(confluenceUser == null ? "Anonymous" : confluenceUser.getKey()), (Object)contentId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return null;
    }

    private boolean isLikeCategory(int categoryId) {
        Settings settings = this.persistenceService.getSettings();
        return settings != null && settings.isLikeCategory(categoryId);
    }

    private boolean anonymousLikeDisabled() {
        Settings settings = this.persistenceService.getSettings();
        return settings == null || !settings.isAnonymousLike();
    }

    private Map<String, Object> buildRatingsResponseMap(ContentEntityObject contentEntityObject, Rating rating) {
        HashMap<String, Object> ratings = new HashMap<String, Object>();
        ArrayList<CategoryRating> categoryRatings = new ArrayList<CategoryRating>();
        RatingItem ratingItem = this.ratingService.getRatingItem(contentEntityObject.getId());
        for (CategoryEntity category : this.categoryService.getCategories(true, contentEntityObject.getId())) {
            int categoryId = category.getID();
            if (this.isLikeCategory(categoryId) && RatingUserHelper.isAnonymous() && this.anonymousLikeDisabled()) continue;
            int currentUserRatingValue = this.ratingService.getUserRatingValue(contentEntityObject, categoryId);
            categoryRatings.add(this.buildCategoryRating(category, ratingItem.getCategoryItem(categoryId), currentUserRatingValue));
        }
        ratings.put(RATING_KEY_USER_COUNT, ratingItem.getUserCount());
        ratings.put(RATING_KEY_ITEMS, categoryRatings);
        if (rating != null) {
            ratings.put(RATING_KEY_CURRENT_RATING, rating);
        }
        return ratings;
    }

    private CategoryRating buildCategoryRating(CategoryEntity category, CategoryItem categoryItem, int currentUserRating) {
        String icon = FontAwesome4to5Helper.migrate(category.getFontAwesomeIcon());
        return new CategoryRating(category.getID(), category.getCategoryName(), category.getDescription(), icon, currentUserRating, categoryItem.getCount(), categoryItem.getAverage());
    }
}

