/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import io.moewe.confluence.addons.rate.ao.RatingEntity;
import io.moewe.confluence.addons.rate.rest.pojo.FeedbackItem;
import io.moewe.confluence.addons.rate.rest.pojo.Rating;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.FeedbackService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.RatingService;
import io.moewe.confluence.addons.rate.util.RatingUserHelper;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/feedback")
@Produces(value={"application/json"})
public class FeedbackResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackService.class);
    private static final int DEFAULT_FEEDBACK_RATING_VALUE = 0;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final int DAY_END_TIME = 86399999;
    private final FeedbackService feedbackService;
    private final RatingService ratingService;
    private final PersistenceService persistenceService;
    private final UserManager userManager;
    private final PageManager pageManager;
    private final I18nResolver i18nResolver;

    public FeedbackResource(FeedbackService feedbackService, RatingService ratingService, PersistenceService persistenceService, @ComponentImport UserManager userManager, @ComponentImport PageManager pageManager, I18nResolver i18nResolver) {
        this.feedbackService = feedbackService;
        this.ratingService = ratingService;
        this.persistenceService = persistenceService;
        this.userManager = userManager;
        this.pageManager = pageManager;
        this.i18nResolver = i18nResolver;
    }

    @ReadOnlyAccessAllowed
    @AnonymousAllowed
    @POST
    @Consumes(value={"application/json"})
    public Response addFeedback(FeedbackItem feedbackItem) {
        Rating rating;
        Settings settings = this.persistenceService.getSettings();
        if (settings.getFeedbackCollectorType() != Settings.FeedbackCollectorType.FEEDBACKMANAGEMENT) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (feedbackItem.getRating() == null || feedbackItem.getRating().getCriterionId() < 0 || feedbackItem.getMessage() == null || feedbackItem.getMessage().length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (feedbackItem.getRating().getCriterionId() == 0) {
            ContentEntityObject contentEntityObject = this.pageManager.getById(feedbackItem.getRating().getContentId());
            rating = this.ratingService.rate(contentEntityObject, 0, 0);
        } else {
            RatingEntity ratingEntity = this.ratingService.getUserRating(feedbackItem.getRating().getContentId(), feedbackItem.getRating().getCriterionId(), false);
            rating = this.ratingService.asRating(ratingEntity);
        }
        if (rating == null) {
            LOGGER.warn("Rating for feedback was not found.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        feedbackItem.setRating(rating);
        if (!rating.getUserItem().getUserKey().equals(RatingUserHelper.getCurrentUserKey(settings))) {
            LOGGER.warn("User {} tried to give a feedback for another users rating {}", (Object)RatingUserHelper.getCurrentUserKey(settings), (Object)rating.getRatingId());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        feedbackItem = this.feedbackService.addFeedback(rating.getRatingId(), feedbackItem.getMessage());
        return Response.ok((Object)feedbackItem).build();
    }

    @ReadOnlyAccessAllowed
    @PUT
    public Response modifyFeedback(FeedbackItem feedbackItem) {
        feedbackItem = this.feedbackService.modifyFeedback(feedbackItem.getId(), feedbackItem.getMessage(), feedbackItem.isRead(), feedbackItem.isArchived());
        return Response.ok((Object)feedbackItem).build();
    }

    @GET
    @Path(value="/{feedbackId}")
    public Response getFeedback(@PathParam(value="feedbackId") int feedbackId) {
        FeedbackItem feedbackItem = this.feedbackService.getFeedback(feedbackId);
        return Response.ok((Object)feedbackItem).build();
    }

    @ReadOnlyAccessAllowed
    @PUT
    @Path(value="/{feedbackId}/{fieldName}")
    public Response modifyFeedback(@PathParam(value="feedbackId") int feedbackId, @PathParam(value="fieldName") String fieldName, String fieldValue) {
        if (fieldName.equals("archived") || fieldName.equals("read")) {
            FeedbackItem feedbackItem = this.feedbackService.getFeedback(feedbackId);
            if (feedbackItem == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (fieldName.equals("archived")) {
                feedbackItem.setArchived(fieldValue.equals("true"));
            }
            if (fieldName.equals("read")) {
                feedbackItem.setRead(fieldValue.equals("true"));
            }
            this.feedbackService.modifyFeedback(feedbackId, feedbackItem.getMessage(), feedbackItem.isRead(), feedbackItem.isArchived());
            return Response.ok((Object)feedbackItem).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    public Response getFeedback(@QueryParam(value="contentId") long contentId) {
        FeedbackItem[] feedbackItems = this.feedbackService.getContentFeedback(contentId);
        return Response.ok((Object)feedbackItems).build();
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @Path(value="/{feedbackId}")
    public Response deleteFeedback(@PathParam(value="feedbackId") int feedbackId) {
        this.feedbackService.deleteFeedback(feedbackId);
        return Response.ok().build();
    }

    @ReadOnlyAccessAllowed
    @GET
    @Path(value="/delete")
    public Response deleteFeedback(@QueryParam(value="start") String start, @QueryParam(value="end") String end) {
        long millisEnd;
        long millisStart;
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            LOGGER.debug("User has no permission to delete.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (start == null || start.isEmpty() || end == null || end.isEmpty()) {
            LOGGER.debug("Startdate or enddate is null or empty.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.empty.error")).build();
        }
        try {
            millisStart = this.convertDate(start);
            millisEnd = this.convertDate(end) + 86399999L;
        }
        catch (ParseException e) {
            String errorFormat = "Startdate or enddate has wrong format.";
            LOGGER.debug(errorFormat);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.format.error")).build();
        }
        this.feedbackService.deleteFeedbacks(millisStart, millisEnd);
        return Response.ok().build();
    }

    @GET
    @Path(value="/export")
    public Response exportFeedback(@QueryParam(value="start") String start, @QueryParam(value="end") String end) {
        long millisEnd;
        long millisStart;
        if (this.userManager.getRemoteUserKey() == null || !this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            LOGGER.debug("User has no permission to export.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (start == null || start.isEmpty() || end == null || end.isEmpty()) {
            LOGGER.debug("Startdate or enddate is null or empty.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.empty.error")).build();
        }
        try {
            millisStart = this.convertDate(start);
            millisEnd = this.convertDate(end) + 86399999L;
        }
        catch (ParseException e) {
            String errorFormat = "Startdate or enddate has wrong format.";
            LOGGER.debug(errorFormat);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18nResolver.getText("io.moewe.confluence.addons.rate.admin.config.dateException.format.error")).build();
        }
        StreamingOutput fileStream = output -> {
            try {
                this.feedbackService.exportFeedback(millisStart, millisEnd, output);
                output.flush();
            }
            catch (Exception e) {
                LOGGER.error("Exception occurs while exporting.", (Throwable)e);
            }
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)"attachment; filename = export-feedback.csv").build();
    }

    private long convertDate(String dateString) throws ParseException {
        Date date = DATE_FORMAT.parse(dateString);
        return date.getTime();
    }
}

