/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.rest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import io.moewe.confluence.addons.rate.rest.pojo.Criterion;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.RatingService;
import io.moewe.confluence.addons.rate.util.SanitizationHelper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/criteria")
public class CriterionResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CriterionResource.class);
    private final CategoryService categoryService;
    private final RatingService ratingService;
    private final ObjectMapper mapper = new ObjectMapper();

    public CriterionResource(CategoryService categoryService, RatingService ratingService) {
        this.categoryService = categoryService;
        this.ratingService = ratingService;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addCategory(Criterion criterion) {
        int id = this.categoryService.addCategory(criterion = SanitizationHelper.Companion.sanitizeCriterion(criterion));
        if (id <= 0) {
            Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)id).build();
        }
        this.ratingService.invalidateCaches();
        criterion.setId(id);
        try {
            String responseBody = this.mapper.writeValueAsString((Object)criterion);
            return Response.ok((Object)responseBody).build();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @ReadOnlyAccessAllowed
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateCategory(@PathParam(value="id") int criterionID, Criterion criterion) {
        if (criterion.getId() != criterionID && criterion.getId() != 0) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"{\"error\" : \"provided criterion ids do not match, please provide valid IDs or none in body\"}").build();
        }
        criterion.setId(criterionID);
        criterion = SanitizationHelper.Companion.sanitizeCriterion(criterion);
        int id = this.categoryService.updateCategory(SanitizationHelper.Companion.sanitizeCriterion(criterion));
        if (id <= 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)id).build();
        }
        try {
            String responseBody = this.mapper.writeValueAsString((Object)criterion);
            return Response.ok((Object)responseBody).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteCategory(@PathParam(value="id") int criterionID) {
        this.categoryService.deleteCategory(criterionID);
        this.ratingService.invalidateCaches();
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCategories(@DefaultValue(value="true") @QueryParam(value="onlyActive") Boolean onlyActive) {
        List<CategoryEntity> categories = this.categoryService.getCategories(onlyActive);
        Stream<Criterion> criteria = categories.stream().map(category -> {
            Criterion criterion = new Criterion();
            criterion.setId(category.getID());
            criterion.setName(category.getCategoryName());
            criterion.setDescription(category.getDescription());
            criterion.setEnabled(category.isEnabled());
            criterion.setOrder(category.getOrder());
            criterion.setFontawesome(category.getFontAwesomeIcon());
            criterion.setContentLabelFilter(category.getContentLabelFilter());
            criterion.setSpaceLabelFilter(category.getSpaceLabelFilter());
            return criterion;
        });
        try {
            return Response.ok((Object)this.mapper.writeValueAsString((Object)criteria.toArray())).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

