/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.provider;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ContentRatingContextProvider
implements ContextProvider {
    private static final String KEY_COLOR_INNER_CIRCLE = "colorInnerCircle";
    private static final String KEY_COLOR_OUTER_CIRCLE = "colorOuterCircle";
    private static final String KEY_COLOR_TEXT = "colorText";
    private static final String KEY_COLOR_BG = "colorBG";
    private static final String DEFAULT_COLOR_INNER_CIRCLE = "#3572B0";
    private static final String DEFAULT_COLOR_OUTER_CIRCLE = "#205081";
    private static final String DEFAULT_COLOR_TEXT = "#333333";
    private static final String DEFAULT_COLOR_BG = "#CCCCCC";
    private static final String SPACE_KEY = "space";
    private static final String KEY_SETTINGS = "settings";
    private final ColourSchemeManager colourSchemeManager;
    private final PageBuilderService pageBuilderService;
    private final PersistenceService persistenceService;

    @Inject
    public ContentRatingContextProvider(@ComponentImport ColourSchemeManager colourSchemeManager, @ComponentImport PageBuilderService pageBuilderService, PersistenceService persistenceService) {
        this.colourSchemeManager = colourSchemeManager;
        this.pageBuilderService = pageBuilderService;
        this.persistenceService = persistenceService;
    }

    public Map<String, Object> getContextMap(Map<String, Object> contextMap) {
        this.pageBuilderService.assembler().resources().requireContext("moewe.content-rating");
        HashMap<String, Object> returnContextMap = new HashMap<String, Object>(contextMap);
        returnContextMap.putAll(MacroUtils.defaultVelocityContext());
        returnContextMap.put(KEY_SETTINGS, this.persistenceService.getSettings());
        returnContextMap.put(KEY_COLOR_BG, DEFAULT_COLOR_BG);
        returnContextMap.put(KEY_COLOR_OUTER_CIRCLE, DEFAULT_COLOR_OUTER_CIRCLE);
        returnContextMap.put(KEY_COLOR_INNER_CIRCLE, DEFAULT_COLOR_INNER_CIRCLE);
        returnContextMap.put(KEY_COLOR_TEXT, DEFAULT_COLOR_TEXT);
        if (returnContextMap.containsKey(SPACE_KEY)) {
            Space space = (Space)returnContextMap.get(SPACE_KEY);
            ColourScheme colourScheme = this.colourSchemeManager.getSpaceColourScheme(space);
            if (colourScheme == null) {
                colourScheme = this.colourSchemeManager.getGlobalColourScheme();
            }
            if (colourScheme != null) {
                this.putColorIfNotWhite(returnContextMap, KEY_COLOR_BG, colourScheme.get("property.style.bordercolour"));
                this.putColorIfNotWhite(returnContextMap, KEY_COLOR_OUTER_CIRCLE, colourScheme.get("property.style.navselectedbgcolour"));
                this.putColorIfNotWhite(returnContextMap, KEY_COLOR_INNER_CIRCLE, colourScheme.get("property.style.navbgcolour"));
                returnContextMap.put(KEY_COLOR_TEXT, colourScheme.get("property.style.headingtextcolour"));
            }
        }
        return returnContextMap;
    }

    private void putColorIfNotWhite(Map<String, Object> returnContextMap, String colorKey, String color) {
        if (color == null || "white".equalsIgnoreCase(color) || "#ffffff".equalsIgnoreCase(color)) {
            return;
        }
        returnContextMap.put(colorKey, color);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }
}

