/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.moewe.atlassian.sdk.internal.util.BatchHelper;
import io.moewe.confluence.addons.rate.ao.RatingEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class UsernameToUserKeyUpgradeTask
implements PluginUpgradeTask {
    private final Logger LOGGER = LoggerFactory.getLogger(UsernameToUserKeyUpgradeTask.class);
    private static final int DEFAULT_OFFSET = 0;
    private final ActiveObjects ao;
    private final UserAccessor userAccessor;

    @Inject
    public UsernameToUserKeyUpgradeTask(@ComponentImport ActiveObjects activeObjects, @ComponentImport UserAccessor userAccessor) {
        this.ao = activeObjects;
        this.userAccessor = userAccessor;
    }

    public int getBuildNumber() {
        return 2020051500;
    }

    public String getShortDescription() {
        return "Migrates general configuration properties to general configuration form.";
    }

    public Collection<Message> doUpgrade() {
        this.LOGGER.warn("Running username to user key migration...");
        Query query = Query.select().from(RatingEntity.class).where("USER_KEY IS NULL OR USER_KEY = ''", new Object[0]);
        BiConsumer<ActiveObjects, RatingEntity[]> usernameToUserKeyFunction = (activeObjects, entities) -> {
            HashMap<String, String> usernameToUserKey = new HashMap<String, String>();
            for (RatingEntity ratingEntity : entities) {
                if (ratingEntity.getUserKey() != null && !ratingEntity.getUserKey().isEmpty()) continue;
                if (ratingEntity.isAnonymousUser()) {
                    ratingEntity.setUserKey(ratingEntity.getUsername());
                } else {
                    String userKey;
                    if (usernameToUserKey.containsKey(ratingEntity.getUsername())) {
                        userKey = (String)usernameToUserKey.get(ratingEntity.getUsername());
                    } else {
                        ConfluenceUser user = this.userAccessor.getUserByName(ratingEntity.getUsername());
                        if (user == null) continue;
                        userKey = user.getKey().getStringValue();
                        usernameToUserKey.put(ratingEntity.getUsername(), userKey);
                    }
                    ratingEntity.setUserKey(userKey);
                }
                ratingEntity.save();
            }
        };
        BatchHelper.process(this.ao, query, RatingEntity.class, usernameToUserKeyFunction, 0, true);
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return "io.moewe.confluence.addons.rate";
    }
}

