/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.CategoryService;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import java.util.Map;

public class StatisticMacro
implements Macro {
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final PersistenceService persistenceService;
    private final CategoryService categoryService;

    public StatisticMacro(PersistenceService persistenceService, SpaceManager spaceManager, CategoryService categoryService, PermissionManager permissionManager) {
        this.persistenceService = persistenceService;
        this.spaceManager = spaceManager;
        this.categoryService = categoryService;
        this.permissionManager = permissionManager;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("ratingCategories", this.categoryService.getCategories(true));
        Settings settings = this.persistenceService.getSettings();
        Settings.Mode mode = settings.getMode();
        context.put("showRatingAverage", Settings.Mode.KNOB.equals((Object)mode));
        context.put("canResetRatings", this.persistenceService.getSettings().isResettableSpaceStatistic() && this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)this.spaceManager.getSpace(parameters.get("spaceKey"))));
        return VelocityUtils.getRenderedTemplate((String)"moewe-content-rating-vm/macro/statistic.vm", (Map)context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

