/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import io.moewe.confluence.addons.rate.service.RatingService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.DisposableBean;

@Named
public class ConfluenceEventListener
implements DisposableBean {
    private final EventPublisher eventPublisher;
    private final PersistenceService persistenceService;
    private final RatingService ratingService;

    @Inject
    public ConfluenceEventListener(PersistenceService persistenceService, RatingService ratingService, @ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.persistenceService = persistenceService;
        this.ratingService = ratingService;
    }

    @EventListener
    public void pageUpdated(PageUpdateEvent event) {
        this.contentUpdate((ContentEntityObject)event.getPage());
    }

    @EventListener
    public void blogpostUpdated(BlogPostUpdateEvent event) {
        this.contentUpdate((ContentEntityObject)event.getBlogPost());
    }

    private void contentUpdate(ContentEntityObject contentEntityObject) {
        List<Integer> resetCategoryIds;
        Settings settings = this.persistenceService.getSettings();
        if (settings.isBlogpostEnabled() && !(resetCategoryIds = settings.getResetCategoryIds()).isEmpty()) {
            this.ratingService.resetContentStatistic(contentEntityObject, resetCategoryIds);
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

