/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.functions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import io.moewe.confluence.addons.rate.ao.CategoryEntity;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0010"}, d2={"Lio/moewe/confluence/addons/rate/functions/ContentLabelFilterPredicate;", "Ljava/util/function/Predicate;", "Lio/moewe/confluence/addons/rate/ao/CategoryEntity;", "contentEntityObject", "Lcom/atlassian/confluence/core/ContentEntityObject;", "<init>", "(Lcom/atlassian/confluence/core/ContentEntityObject;)V", "contentLabels", "", "Lcom/atlassian/confluence/labels/Label;", "kotlin.jvm.PlatformType", "", "Ljava/util/List;", "test", "", "category", "rate"})
public final class ContentLabelFilterPredicate
implements Predicate<CategoryEntity> {
    @NotNull
    private final ContentEntityObject contentEntityObject;
    private final List<Label> contentLabels;

    public ContentLabelFilterPredicate(@NotNull ContentEntityObject contentEntityObject) {
        Intrinsics.checkNotNullParameter(contentEntityObject, "contentEntityObject");
        this.contentEntityObject = contentEntityObject;
        this.contentLabels = this.contentEntityObject.getLabels();
    }

    @Override
    public boolean test(@NotNull CategoryEntity category) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(category, "category");
                if (category.getContentLabelFilter() == null) break block3;
                String string = category.getContentLabelFilter();
                Intrinsics.checkNotNullExpressionValue(string, "getContentLabelFilter(...)");
                if (!StringsKt.isBlank(string)) break block4;
            }
            return true;
        }
        String string = category.getContentLabelFilter();
        Intrinsics.checkNotNullExpressionValue(string, "getContentLabelFilter(...)");
        String[] stringArray = new String[]{"\\s*,+\\*"};
        List labels = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        for (Label contentLabel : this.contentLabels) {
            String string2;
            Intrinsics.checkNotNullExpressionValue(contentLabel.getName(), "getName(...)");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            if (!labels.contains(string3)) continue;
            return true;
        }
        return false;
    }
}

