/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpaceCondition
extends BaseConfluenceCondition {
    private final SpaceManager spaceManager;
    private final PersistenceService persistenceService;

    public SpaceCondition(@ComponentImport SpaceManager spaceManager, PersistenceService persistenceService) {
        this.spaceManager = spaceManager;
        this.persistenceService = persistenceService;
    }

    protected boolean shouldDisplay(WebInterfaceContext context) {
        Settings settings = this.persistenceService.getSettings();
        return context != null && this.displayForSpace(context, settings);
    }

    private boolean displayForSpace(WebInterfaceContext context, Settings settings) {
        Object spaceKey;
        Space space = context.getSpace();
        if (space == null && (spaceKey = context.getParameter("spaceKey")) != null) {
            space = this.spaceManager.getSpace((String)spaceKey);
        }
        if (space != null) {
            spaceKey = space.getKey();
            List<Object> spaceKeys = new ArrayList();
            if (settings.getSpaceKeys() != null) {
                spaceKeys = Arrays.asList(settings.getSpaceKeys());
            }
            switch (this.getSpaceRestriction(settings)) {
                case EXCLUDE: {
                    return !spaceKeys.contains(spaceKey);
                }
                case INCLUDE: {
                    return spaceKeys.contains(spaceKey);
                }
                case NONE: {
                    return true;
                }
            }
        }
        return false;
    }

    private Settings.SpaceRestriction getSpaceRestriction(Settings settings) {
        return Settings.SpaceRestriction.getSpaceRestrictionWithFallback(settings.getSpaceRestriction().name());
    }
}

