/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.condition;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.moewe.confluence.addons.rate.rest.pojo.Settings;
import io.moewe.confluence.addons.rate.service.PersistenceService;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ContentRatingCondition
extends BaseConfluenceCondition {
    private static final String CONTENT_TYPE_BLOGPOST = "blogpost";
    private static final String CONTENT_TYPE_PAGE = "page";
    private final PageManager pageManager;
    private final PersistenceService persistenceService;

    public ContentRatingCondition(@ComponentImport PageManager pageManager, PersistenceService persistenceService) {
        this.pageManager = pageManager;
        this.persistenceService = persistenceService;
    }

    protected boolean shouldDisplay(WebInterfaceContext context) {
        Settings settings = this.persistenceService.getSettings();
        return context != null && this.displayForUser(settings) && this.displayForContentType(context, settings) && this.displayForGlobalContentLabels(context, settings);
    }

    private boolean displayForGlobalContentLabels(WebInterfaceContext context, Settings settings) {
        if (settings.getContentLabelFilters().length == 0) {
            return true;
        }
        List<String> labels = Arrays.asList(settings.getContentLabelFilters());
        ContentEntityObject contentEntity = this.getContentEntity(context);
        if (contentEntity == null || contentEntity.getLabels() == null) {
            return false;
        }
        for (Label label : contentEntity.getLabels()) {
            if (!labels.contains(label.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isHomeOfSpace(WebInterfaceContext context) {
        return context.getSpace() != null && context.getSpace().getHomePage() != null && context.getSpace().getHomePage().isCurrent();
    }

    private boolean displayForContentType(WebInterfaceContext context, Settings settings) {
        ContentEntityObject contentEntity = this.getContentEntity(context);
        if (contentEntity != null) {
            String contentType;
            switch (contentType = contentEntity.getType()) {
                case "page": {
                    return settings.isPageEnabled();
                }
                case "blogpost": {
                    return settings.isBlogpostEnabled();
                }
            }
        }
        return this.isHomeOfSpace(context) && settings.isPageEnabled();
    }

    private @Nullable ContentEntityObject getContentEntity(WebInterfaceContext context) {
        Object contentId;
        AbstractPage page = context.getPage();
        if (page == null && (contentId = context.getParameter("contentId")) != null) {
            return this.pageManager.getById(Long.parseLong((String)contentId));
        }
        return page;
    }

    private boolean displayForUser(Settings settings) {
        return AuthenticatedUserThreadLocal.get() != null || settings.hasAnonymousAccess();
    }
}

