/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class RateBandanaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateBandanaManager.class);
    private final BandanaManager bandanaManager;
    private static final String MOEWE_PREFIX = "moewe.";
    private final ConfluenceBandanaContext context;
    private static final String RATE_PREFIX = "rate.";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Inject
    public RateBandanaManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.context = new ConfluenceBandanaContext();
    }

    public <T> T getValue(String key, Class<T> clazz) {
        Object possibleOldFormValue = this.bandanaManager.getValue((BandanaContext)this.context, this.getKey(key));
        try {
            if (possibleOldFormValue != null) {
                if (possibleOldFormValue instanceof String) {
                    return MAPPER.readValue((String)possibleOldFormValue, clazz);
                }
                try {
                    Object oldSettings = possibleOldFormValue;
                    String oldSettingsAsString = MAPPER.writeValueAsString(oldSettings);
                    T newSettings = MAPPER.readValue(oldSettingsAsString, clazz);
                    this.setValue(key, newSettings);
                    return newSettings;
                }
                catch (ClassCastException e) {
                    LOGGER.error("Please restart Confluence to clear classloader caches. Thank you.");
                    throw new RuntimeException("Please restart Confluence to clear classloader caches. Thank you.");
                }
            }
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error getting form", e);
        }
    }

    public void setValue(String key, Object value) {
        try {
            this.bandanaManager.setValue((BandanaContext)this.context, this.getKey(key), (Object)MAPPER.writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("There was an error saving the form.", e);
        }
    }

    private String getKey(String key) {
        return "moewe.rate." + key;
    }
}

