/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.confluence.addons.rate.actions;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceReportAction
extends AbstractSpaceAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpaceReportAction.class);
    private XhtmlContent xhtmlContent;

    public String getStatistics() {
        return "input";
    }

    public String renderStatisticsMacro() {
        Object macro = "<ac:structured-macro ac:name=\"statistic-macro\">";
        Space space = this.getSpace();
        if (space != null) {
            macro = (String)macro + "<ac:parameter ac:name=\"spaceKey\"><ri:space ri:space-key=\"" + space.getKey() + "\" /></ac:parameter>";
        }
        macro = (String)macro + "</ac:structured-macro>";
        Page page = new Page();
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)page.toPageContext());
        try {
            return this.xhtmlContent.convertStorageToView((String)macro, (ConversionContext)conversionContext);
        }
        catch (XhtmlException | XMLStreamException e) {
            LOGGER.error(e.getMessage(), e);
            return "There was an error. Please check the logs.";
        }
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }
}

