/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.internal.util;

import com.atlassian.activeobjects.external.ActiveObjects;
import java.util.function.BiConsumer;
import net.java.ao.Entity;
import net.java.ao.Query;

public class BatchHelper {
    public static <T extends Entity> void process(ActiveObjects activeObjects, Query query, Class<T> entityClass, BiConsumer<ActiveObjects, T[]> batchFunction, int offset, boolean forceOffset) {
        offset = forceOffset ? offset : 0;
        Entity[] entities = (Entity[])activeObjects.find(entityClass, query.offset(offset).limit(500));
        if (entities == null || entities.length == 0) {
            return;
        }
        activeObjects.executeInTransaction(() -> {
            batchFunction.accept(activeObjects, entities);
            return null;
        });
        BatchHelper.process(activeObjects, query, entityClass, batchFunction, offset + entities.length, forceOffset);
    }

    public static <T extends Entity> void processEach(ActiveObjects activeObjects, Query query, Class<T> entityClass, BiConsumer<ActiveObjects, T> batchFunction, int offset, boolean forceOffset) {
        BatchHelper.process(activeObjects, query, entityClass, (activeObjects1, entities) -> {
            for (Entity entity : entities) {
                batchFunction.accept(activeObjects, entity);
            }
        }, offset, forceOffset);
    }
}

