/*
 * Decompiled with CFR 0.152.
 */
package io.moewe.atlassian.sdk.auiforms.util;

import com.atlassian.sal.api.message.I18nResolver;
import java.util.Locale;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidatorFactory {
    private ValidatorFactory() {
    }

    public static Validator getValidatior(final I18nResolver i18nResolver) {
        Configuration<?> validationConfig = Validation.byDefaultProvider().configure();
        final MessageInterpolator defaultMessageInterpolator = validationConfig.getDefaultMessageInterpolator();
        javax.validation.ValidatorFactory validatorFactory = validationConfig.messageInterpolator(new MessageInterpolator(){

            @Override
            public String interpolate(String messageKey, MessageInterpolator.Context context) {
                String message = i18nResolver.getText(messageKey);
                if (!messageKey.equals(message)) {
                    return message;
                }
                return defaultMessageInterpolator.interpolate(messageKey, context);
            }

            @Override
            public String interpolate(String messageKey, MessageInterpolator.Context context, Locale locale) {
                String message = i18nResolver.getText(locale, messageKey);
                if (messageKey.equals(message)) {
                    return message;
                }
                return defaultMessageInterpolator.interpolate(messageKey, context, locale);
            }
        }).buildValidatorFactory();
        return validatorFactory.getValidator();
    }
}

