define('confluence-paste/autoconvert/transformers/ahapaste', [
  'tinymce',
], function(tinymce) {
  'use strict';
  function isAhaUrl(url) {
    return (
      /^https:\/\/[a-z0-9]+[a-z0-9\-]+[a-z0-9]\.aha\.io\/(published|shared)/i.test(
        url,
      ) || /^http:\/\/reallybigaha\.lvh\.me:3000\/(published|shared)/i.test(url)
    );
  }

  function AhaPaste() {
    var pasteHandler = function(uri, node, done) {
      if (isAhaUrl(uri.source)) {
        var macro = {
          name: 'aha!-roadmaps-for-confluence',
          params: {
            Link: uri.source.split('?')[0],
          },
          defaultParameterValue: '',
        };
        tinymce.plugins.Autoconvert.convertMacroToDom(macro, done, done);
      } else {
        done();
      }
    };

    tinymce.plugins.Autoconvert.autoConvert.addHandler(pasteHandler);
  }

  return AhaPaste;
});

require('confluence/module-exporter').safeRequire(
  'confluence-paste/autoconvert/transformers/ahapaste',
  function(AhaPaste) {
    require('ajs').bind('init.rte', AhaPaste);
  },
);
