/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlSerializer;

public class CompactXmlSerializer
extends XmlSerializer {
    public CompactXmlSerializer(CleanerProperties props) {
        super(props);
    }

    @Override
    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        List<? extends BaseToken> tagChildren = tagNode.getAllChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator<? extends BaseToken> childrenIt = tagChildren.listIterator();
            while (childrenIt.hasNext()) {
                String content;
                BaseToken item = childrenIt.next();
                if (item == null) continue;
                if (item instanceof ContentNode) {
                    content = ((ContentNode)item).getContent().trim();
                    writer.write(this.dontEscape(tagNode) ? content.replaceAll("]]>", "]]&gt;") : this.escapeXml(content));
                    if (!childrenIt.hasNext()) continue;
                    if (!this.isWhitespaceString(childrenIt.next())) {
                        writer.write("\n");
                    }
                    childrenIt.previous();
                    continue;
                }
                if (item instanceof CommentNode) {
                    content = ((CommentNode)item).getCommentedContent().trim();
                    writer.write(content);
                    continue;
                }
                item.serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }

    private boolean isWhitespaceString(Object object) {
        if (object != null) {
            String s = object.toString();
            return s != null && "".equals(s.trim());
        }
        return false;
    }
}

