/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.acdc.common.view;

import hu.metainf.acdc.common.HeaderCommanderIcon;
import hu.metainf.acdc.common.ViewFormat;
import hu.metainf.acdc.common.data.AcdcHeader;
import hu.metainf.acdc.common.data.AcdcPage;
import hu.metainf.acdc.common.service.HeaderOrderer;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlCodeGenerator {
    private ViewFormat viewFormat;
    private int headerCounter = 0;
    private int childCounter = 0;
    private boolean expandHeaders;
    private HeaderCommanderIcon headerCommanderIcon;
    private boolean pdfOutput = false;
    private boolean expandPages;
    private boolean openablePageTree;
    boolean includeRootPageHeaders;

    public HtmlCodeGenerator(Map<String, String> map) {
        String expandHeadersInput = map.get("expandHeaders");
        String expandPages = map.get("expandPages");
        this.includeRootPageHeaders = Boolean.parseBoolean(map.get("showParentPageHeaders"));
        this.openablePageTree = Boolean.parseBoolean(map.get("openablePageTree"));
        this.setExpandPages(expandPages);
        this.viewFormat = ViewFormat.CHILDREN_DISPLAY;
        this.setExpandHeaders(expandHeadersInput);
        this.headerCommanderIcon = HeaderCommanderIcon.PLUS_MINUS_CIRCLE;
    }

    public void setPdfOutputType() {
        this.pdfOutput = true;
        this.expandHeaders = true;
    }

    private void setExpandPages(String expandpagesInput) {
        boolean expandPages = false;
        if (expandpagesInput != null) {
            expandPages = expandpagesInput.equals("Expand all");
        }
        this.expandPages = expandPages;
    }

    private void setExpandHeaders(String expandHeadersInput) {
        boolean expandHeaders = false;
        if (expandHeadersInput != null) {
            expandHeaders = expandHeadersInput.equals("Expand all");
        }
        this.expandHeaders = expandHeaders;
    }

    public String acdcPageToHtml(AcdcPage pageList) {
        StringBuilder outputString = new StringBuilder("");
        switch (this.viewFormat) {
            case CHILDREN_DISPLAY: {
                outputString.append("<div class='metainf-acdc-orig'>");
            }
        }
        if (pageList != null) {
            if (this.includeRootPageHeaders) {
                outputString.append(this.headersToHtml(pageList.getAcdcHeaders()));
            }
            outputString.append(this.childPagesToHtml(pageList, ""));
        } else {
            outputString.append("null!");
        }
        outputString.append("</div>");
        return outputString.toString();
    }

    private String childPagesToHtml(AcdcPage acdcPage, String contentDepth) {
        StringBuilder htmlOut = new StringBuilder("");
        if (acdcPage.getChildren().size() > 0) {
            List<AcdcPage> children = acdcPage.getChildren();
            if (this.openablePageTree && this.childCounter > 0) {
                htmlOut.append(this.addChildPageCommander(children.size(), "left", acdcPage.getId()));
            }
            htmlOut.append("<ul class='pages-ul " + (this.childCounter > 0 && this.openablePageTree && !this.expandPages ? "closed" : "open") + "-pages' id='page-commander-ul-" + acdcPage.getId() + "'>");
            ++this.childCounter;
            for (int i = 0; i < children.size(); ++i) {
                AcdcPage acdcPageChild = children.get(i);
                htmlOut.append(this.onePageToHtml(acdcPageChild, contentDepth + i + "."));
            }
            htmlOut.append("</ul>");
        }
        return htmlOut.toString();
    }

    private String onePageToHtml(AcdcPage acdcPage, String contentDepth) {
        StringBuilder htmlOut = new StringBuilder("");
        if (acdcPage.isVisible()) {
            String linkOfPage = "<a href='" + acdcPage.getPageAddress() + "' target='_top'>";
            switch (this.viewFormat) {
                case CHILDREN_DISPLAY: {
                    htmlOut.append("<li class='page'><span>");
                    htmlOut.append(linkOfPage + StringEscapeUtils.escapeHtml4((String)acdcPage.getTitle()) + "</a>");
                    htmlOut.append("</span>");
                    if (!this.pdfOutput) {
                        htmlOut.append(this.addHeaderCommander(acdcPage.getAcdcHeaders().size(), "left"));
                    }
                    htmlOut.append("</li>");
                }
            }
            htmlOut.append(this.headersToHtml(acdcPage.getAcdcHeaders()));
        }
        htmlOut.append(this.childPagesToHtml(acdcPage, contentDepth));
        return htmlOut.toString();
    }

    private String addHeaderCommander(int numberOfHeaders, String orientation) {
        StringBuilder headerCommander = new StringBuilder("");
        if (numberOfHeaders > 0) {
            String openOrClose = this.expandHeaders ? "close" : "open";
            headerCommander.append("<span ");
            headerCommander.append("class='commander-" + openOrClose + "-" + this.headerCommanderIcon.getCssClassPost() + " " + orientation + "'");
            headerCommander.append(" id='header-commander-icon-" + this.headerCounter + "'");
            headerCommander.append(" title='" + (this.expandHeaders ? "Close" : "Open") + " headers of this page.'");
            headerCommander.append("></span>");
        }
        return headerCommander.toString();
    }

    private String addChildPageCommander(int numberOfchildren, String orientation, String id) {
        StringBuilder cpCommander = new StringBuilder("");
        if (numberOfchildren > 0) {
            String openOrClose = this.expandPages ? "close" : "open";
            cpCommander.append("<span ");
            cpCommander.append("class='page-commander-" + openOrClose + "-" + this.headerCommanderIcon.getCssClassPost() + " " + orientation + "'");
            cpCommander.append(" id='page-commander-icon-" + id + "'");
            cpCommander.append(" title='Open children of this page.'");
            cpCommander.append("></span>");
        }
        return cpCommander.toString();
    }

    private String headersToHtml(List<AcdcHeader> acdcHeaders) {
        StringBuilder htmlOut = new StringBuilder("");
        if (acdcHeaders.size() > 0) {
            HeaderOrderer.orderHeaders(acdcHeaders);
            htmlOut.append("<ul class='header-ul " + (this.expandHeaders ? "" : "closed-headers") + "' id='header-commander-ul-" + this.headerCounter + "'>");
            int ulCounter = 1;
            for (AcdcHeader acdcHeader : acdcHeaders) {
                htmlOut.append(this.ulHandler(acdcHeader.getHeaderLvl(), ulCounter));
                ulCounter = acdcHeader.getHeaderLvl();
                htmlOut.append("<li><a href='" + acdcHeader.getHeaderIdAddress() + "' target='_top'>" + acdcHeader.getText() + "</li></a>");
            }
            htmlOut.append(this.ulHandler(0, ulCounter));
        }
        ++this.headerCounter;
        return htmlOut.toString();
    }

    private String ulHandler(int requiredLevel, int actualLevel) {
        Object uls;
        block4: {
            uls = "";
            if (requiredLevel == actualLevel) break block4;
            if (requiredLevel > actualLevel) {
                for (int i = actualLevel; i < requiredLevel; ++i) {
                    uls = (String)uls + "<ul>";
                }
            } else {
                for (int i = requiredLevel; i < actualLevel; ++i) {
                    uls = (String)uls + "</ul>";
                }
            }
        }
        return uls;
    }
}

