/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.acdc.service;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import hu.metainf.acdc.common.data.AcdcHeader;
import hu.metainf.acdc.common.data.AcdcPage;
import hu.metainf.acdc.common.service.HeadingLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class PagesService {
    private static final Logger logger = Logger.getLogger(PagesService.class);
    private final String baseUrl;
    private final HeadingLevel headingLevel;
    private int maximumPageDepthLevel;
    private int actualPageDepthLevel = 0;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final Page firstPage;
    private final String filteringLabel;
    private final boolean whiteList;
    private final boolean includeRootHeaders;

    public PagesService(Map<String, String> propertiesInput, ConversionContext conversionContext, PageManager pageManager, SettingsManager settingsManager, PermissionManager permissionManager) {
        logger.debug("conversionContext: " + conversionContext);
        logger.debug("pageManager: " + pageManager);
        logger.debug("settingsManager: " + settingsManager);
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.baseUrl = settingsManager.getGlobalSettings().getBaseUrl();
        String minimumHeadingLevel = propertiesInput.get("minimumHeadingLevel");
        String maximumHeadingLevel = propertiesInput.get("maximumHeadingLevel");
        String parentPageInput = propertiesInput.get("parentPage");
        this.includeRootHeaders = Boolean.parseBoolean(propertiesInput.get("showParentPageHeaders"));
        String depthOfDescendantsInput = propertiesInput.get("depthOfDescendants");
        this.filteringLabel = propertiesInput.getOrDefault("filteringLabel", "");
        this.whiteList = propertiesInput.getOrDefault("whiteList", "").equals("Whitelist");
        this.headingLevel = new HeadingLevel(minimumHeadingLevel, maximumHeadingLevel);
        this.setPageDepthLevel(depthOfDescendantsInput);
        ContentEntityObject contentEntity = conversionContext.getEntity();
        if (contentEntity != null) {
            this.firstPage = this.findFirstPage(conversionContext.getSpaceKey(), contentEntity.getId(), parentPageInput);
        } else {
            this.firstPage = null;
            logger.error("Cannot get first page because content entity is null");
        }
    }

    public AcdcPage collectPages() {
        return this.fillOneAcdcPage(this.firstPage, true);
    }

    private AcdcPage fillOneAcdcPage(Page page, boolean isFirstPage) {
        AcdcPage acdcPage = new AcdcPage();
        if (this.hasAccess(page) && (!this.isFilteredByLabel(page) || isFirstPage)) {
            ++this.actualPageDepthLevel;
            acdcPage.setId(page.getIdAsString());
            acdcPage.setTitle(page.getTitle());
            acdcPage.setPageAddress(this.baseUrl + "/pages/viewpage.action?pageId=" + acdcPage.getId());
            acdcPage.setVisible(true);
            logger.debug(acdcPage + "; isFirstPage: " + isFirstPage);
            if (!(!this.includeRootHeaders && isFirstPage || this.headingLevel.getRegex().equals(""))) {
                acdcPage.setAcdcHeaders(this.collectHeaders(page, acdcPage.getId()));
            }
            if (this.maximumPageDepthLevel == 0 || this.actualPageDepthLevel != this.maximumPageDepthLevel + 1) {
                for (Page childPage : page.getSortedChildren()) {
                    acdcPage.addOneChild(this.fillOneAcdcPage(childPage, false));
                }
            }
            --this.actualPageDepthLevel;
        } else {
            acdcPage.setVisible(false);
        }
        return acdcPage;
    }

    private boolean isFilteredByLabel(Page page) {
        boolean filtered = this.whiteList;
        if (StringUtils.isNotBlank((CharSequence)this.filteringLabel)) {
            List labelNames = page.getLabels().stream().map(Label::getName).collect(Collectors.toList());
            filtered = Collections.disjoint(labelNames, Arrays.asList(this.filteringLabel.split(","))) == this.whiteList;
        }
        return filtered;
    }

    private List<AcdcHeader> collectHeaders(Page page, String pageId) {
        String pageContent = page.getBodyAsString();
        ArrayList<AcdcHeader> acdcHeaders = new ArrayList<AcdcHeader>();
        HtmlCleaner cleaner = new HtmlCleaner();
        TagNode[] tagNodes = cleaner.clean(pageContent).getChildTags();
        logger.debug("         tagNodes.length -> " + tagNodes.length);
        this.fillAcdcHeadersList(acdcHeaders, tagNodes, pageId, page);
        logger.debug("         acdcHeaders.size    -> " + acdcHeaders.size());
        return acdcHeaders;
    }

    private void fillAcdcHeadersList(List<AcdcHeader> acdcHeaders, TagNode[] tagNodes, String pageId, Page page) {
        for (TagNode tagNodeChild : tagNodes) {
            if (tagNodeChild.getName().toLowerCase().matches(this.headingLevel.getRegex())) {
                AcdcHeader acdcHeader = new AcdcHeader();
                int headerLvl = 0;
                try {
                    headerLvl = Integer.parseInt(tagNodeChild.getName().substring(1));
                }
                catch (Exception e) {
                    logger.error("Can not parse string (" + tagNodeChild.getName().substring(1) + ") to int");
                }
                acdcHeader.setHeaderLvl(headerLvl);
                acdcHeader.setText(tagNodeChild.getText().toString());
                String url = this.baseUrl + "/pages/viewpage.action?pageId=" + pageId + "#" + AbstractPageLink.generateAnchor((PageContext)page.toPageContext(), (String)acdcHeader.getText());
                acdcHeader.setHeaderIdAddress(url);
                logger.debug("       acncHeader -> (" + acdcHeader.getHeaderLvl() + ") -> " + acdcHeader.getText() + " (" + acdcHeader.getHeaderIdAddress() + ")");
                if (!acdcHeader.getText().equals("") && !acdcHeader.getText().equals("&nbsp;")) {
                    acdcHeaders.add(acdcHeader);
                }
            }
            this.fillAcdcHeadersList(acdcHeaders, tagNodeChild.getChildTags(), pageId, page);
        }
    }

    private Page findFirstPage(String mainSpaceKey, Long mainPageId, String customStartPageTitle) {
        logger.debug("mainPageId: " + mainPageId);
        logger.debug("startPageIdInput: " + customStartPageTitle);
        logger.debug("pageManager: " + this.pageManager);
        Page result = null;
        if (customStartPageTitle != null) {
            String[] separatedInput = customStartPageTitle.split(":", 2);
            if (separatedInput.length > 1) {
                result = this.pageManager.getPage(separatedInput[0], separatedInput[1]);
            }
            if (result == null) {
                result = this.pageManager.getPage(mainSpaceKey, customStartPageTitle);
            }
        }
        if (result == null) {
            result = this.pageManager.getPage(mainPageId.longValue());
        }
        return result;
    }

    private void setPageDepthLevel(String pageDepthLevelInput) {
        int result = 0;
        logger.debug("pageDepthLevelInput: " + pageDepthLevelInput);
        if (pageDepthLevelInput != null) {
            try {
                result = Integer.parseInt(pageDepthLevelInput);
            }
            catch (NumberFormatException e) {
                logger.warn("Can not convert '" + pageDepthLevelInput + "' to Integer!");
            }
        }
        logger.debug("pageDepthLevel: " + result);
        this.maximumPageDepthLevel = result;
    }

    private boolean hasAccess(Page page) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)page);
    }
}

