/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.acdc.common.service;

import hu.metainf.acdc.common.data.AcdcHeader;
import java.util.Arrays;
import java.util.List;

public class HeaderOrderer {
    public static void orderHeaders(List<AcdcHeader> acdcHeaders) {
        if (acdcHeaders != null && acdcHeaders.size() > 0) {
            if (acdcHeaders.size() == 1) {
                acdcHeaders.get(0).setHeaderLvl(1);
            } else {
                HeaderOrderer.sliceHeaders(acdcHeaders);
            }
        }
    }

    private static void sliceHeaders(List<AcdcHeader> acdcHeaders) {
        int actualHighestLvl = acdcHeaders.get(0).getHeaderLvl();
        int startElement = 0;
        boolean[] headerLevels = new boolean[]{false, false, false, false, false, false};
        headerLevels[actualHighestLvl - 1] = true;
        for (int i = 1; i < acdcHeaders.size(); ++i) {
            if (acdcHeaders.get(i).getHeaderLvl() <= actualHighestLvl) {
                HeaderOrderer.setLevelsInABlock(acdcHeaders, startElement, i, headerLevels);
                startElement = i;
                actualHighestLvl = acdcHeaders.get(i).getHeaderLvl();
                Arrays.fill(headerLevels, Boolean.FALSE);
                headerLevels[actualHighestLvl - 1] = true;
                if (i != acdcHeaders.size() - 1) continue;
                acdcHeaders.get(i).setHeaderLvl(1);
                continue;
            }
            headerLevels[acdcHeaders.get((int)i).getHeaderLvl() - 1] = true;
            if (i != acdcHeaders.size() - 1) continue;
            HeaderOrderer.setLevelsInABlock(acdcHeaders, startElement, i + 1, headerLevels);
        }
    }

    private static void setLevelsInABlock(List<AcdcHeader> acdcHeaders, int startElement, int lastElement, boolean[] existingLevels) {
        int[] levelSetter = HeaderOrderer.generateLevelSetters(existingLevels);
        for (int i = startElement; i < lastElement; ++i) {
            acdcHeaders.get(i).setHeaderLvl(levelSetter[acdcHeaders.get(i).getHeaderLvl() - 1]);
        }
    }

    private static int[] generateLevelSetters(boolean[] existingLevels) {
        int[] levelSetter = new int[existingLevels.length];
        int levelCounter = 1;
        for (int i = 0; i < existingLevels.length; ++i) {
            if (!existingLevels[i]) continue;
            levelSetter[i] = levelCounter++;
        }
        return levelSetter;
    }
}

