/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DomSerializer {
    private static final String CSS_COMMENT_START = "/*";
    private static final String CSS_COMMENT_END = "*/";
    private static final String NEW_LINE = "\n";
    private static final String XML_10 = "1.0";
    private static final String XML_11 = "1.1";
    protected CleanerProperties props;
    protected boolean escapeXml = true;
    protected boolean deserializeCdataEntities = false;
    protected boolean strictErrorChecking = true;
    protected String xmlVersion = "1.0";

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) throws Exception {
        if (xmlVersion != XML_10 && xmlVersion != XML_11) {
            throw new Exception("Invalid XML version - must be 1.0 or 1.1");
        }
        this.xmlVersion = xmlVersion;
    }

    public DomSerializer(CleanerProperties props, boolean escapeXml, boolean deserializeCdataEntities, boolean strictErrorChecking) {
        this.props = props;
        this.escapeXml = escapeXml;
        this.deserializeCdataEntities = deserializeCdataEntities;
        this.strictErrorChecking = strictErrorChecking;
    }

    public DomSerializer(CleanerProperties props, boolean escapeXml, boolean deserializeCdataEntities) {
        this.props = props;
        this.escapeXml = escapeXml;
        this.deserializeCdataEntities = deserializeCdataEntities;
    }

    public DomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public DomSerializer(CleanerProperties props) {
        this(props, true);
    }

    protected Document createDocument(TagNode rootNode) throws ParserConfigurationException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        if (rootNode.getDocType() != null) {
            String qualifiedName = rootNode.getDocType().getPart1();
            String publicId = rootNode.getDocType().getPublicId();
            String systemId = rootNode.getDocType().getSystemId();
            if (qualifiedName == null) {
                qualifiedName = "html";
            }
            DocumentType documentType = impl.createDocumentType(qualifiedName, publicId, systemId);
            if (qualifiedName.equals("HTML")) {
                qualifiedName = "html";
            }
            document = impl.createDocument(rootNode.getNamespaceURIOnPath(""), qualifiedName, documentType);
            document.setXmlVersion(this.xmlVersion);
        } else {
            document = builder.newDocument();
            document.setXmlVersion(this.xmlVersion);
            Element rootElement = document.createElement(rootNode.getName());
            document.appendChild(rootElement);
        }
        if (this.props.isAllowInvalidAttributeNames() || !this.strictErrorChecking) {
            document.setStrictErrorChecking(false);
        }
        Map<String, String> attributes = rootNode.getAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (!this.props.isAllowInvalidAttributeNames()) {
                attrName = Utils.sanitizeXmlIdentifier(attrName, this.props.getInvalidXmlAttributeNamePrefix());
            }
            if (attrName == null || !Utils.isValidXmlIdentifier(attrName) && !this.props.isAllowInvalidAttributeNames()) continue;
            if (this.escapeXml) {
                attrValue = Utils.deserializeEntities(attrValue, this.props.isRecognizeUnicodeChars());
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            document.getDocumentElement().setAttribute(attrName, attrValue);
            if (!attrName.equalsIgnoreCase("id")) continue;
            document.getDocumentElement().setIdAttribute(attrName, true);
        }
        return document;
    }

    public Document createDOM(TagNode rootNode) throws ParserConfigurationException {
        Document document = this.createDocument(rootNode);
        this.createSubnodes(document, document.getDocumentElement(), rootNode.getAllChildren());
        return document;
    }

    protected boolean isScriptOrStyle(Element element) {
        String tagName = element.getNodeName();
        return "script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName);
    }

    protected boolean dontEscape(Element element) {
        return this.props.isUseCdataFor(element.getNodeName()) && (!element.hasChildNodes() || element.getTextContent() == null || element.getTextContent().trim().length() == 0);
    }

    protected String outputCData(CData cdata) {
        return cdata.getContentWithoutStartAndEndTokens();
    }

    protected String deserializeCdataEntities(String input) {
        return Utils.deserializeEntities(input, this.props.isRecognizeUnicodeChars());
    }

    protected void createSubnodes(Document document, Element element, List<? extends BaseToken> tagChildren) {
        if (tagChildren != null) {
            CDATASection cdata = null;
            if (this.props.isUseCdataFor(element.getTagName())) {
                cdata = document.createCDATASection("");
                element.appendChild(document.createTextNode(CSS_COMMENT_START));
                element.appendChild(cdata);
            }
            for (BaseToken baseToken : tagChildren) {
                if (baseToken instanceof CommentNode) {
                    CommentNode commentNode = (CommentNode)baseToken;
                    Comment comment = document.createComment(commentNode.getContent());
                    element.appendChild(comment);
                    continue;
                }
                if (baseToken instanceof ContentNode) {
                    ContentNode contentNode = (ContentNode)baseToken;
                    String content = contentNode.getContent();
                    boolean specialCase = this.props.isUseCdataFor(element.getTagName());
                    if (this.props.isRecognizeUnicodeChars() && this.props.isTranslateSpecialEntities()) {
                        content = Utils.deserializeEntities(content, this.props.isRecognizeUnicodeChars());
                    }
                    if ((this.escapeXml || this.props.isTranslateSpecialEntities()) && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    if (specialCase && baseToken instanceof CData) {
                        content = ((CData)baseToken).getContentWithoutStartAndEndTokens();
                    }
                    if (specialCase && this.deserializeCdataEntities) {
                        content = this.deserializeCdataEntities(content);
                    }
                    if (cdata != null) {
                        cdata.appendData(content);
                        continue;
                    }
                    element.appendChild(document.createTextNode(content));
                    continue;
                }
                if (baseToken instanceof TagNode) {
                    TagNode subTagNode = (TagNode)baseToken;
                    String name = Utils.sanitizeXmlIdentifier(subTagNode.getName(), this.props.getInvalidXmlAttributeNamePrefix());
                    if (name == null) {
                        ContentNode contentNode = new ContentNode(subTagNode.getName() + subTagNode.getText().toString());
                        String content = contentNode.getContent();
                        content = Utils.escapeXml(content, this.props, true);
                        element.appendChild(document.createTextNode(content));
                        continue;
                    }
                    Element subelement = document.createElement(name);
                    Map<String, String> attributes = subTagNode.getAttributes();
                    for (Map.Entry<String, String> entry : attributes.entrySet()) {
                        String attrName = entry.getKey();
                        String attrValue = entry.getValue();
                        if (this.escapeXml) {
                            attrValue = Utils.deserializeEntities(attrValue, true);
                            attrValue = Utils.escapeXml(attrValue, this.props, true);
                        }
                        if (!this.props.isAllowInvalidAttributeNames()) {
                            attrName = Utils.sanitizeXmlIdentifier(attrName, this.props.getInvalidXmlAttributeNamePrefix());
                        }
                        if (attrName == null || !Utils.isValidXmlIdentifier(attrName) && !this.props.isAllowInvalidAttributeNames()) continue;
                        subelement.setAttribute(attrName, attrValue);
                        if (!attrName.equalsIgnoreCase("id")) continue;
                        subelement.setIdAttribute(attrName, true);
                    }
                    this.createSubnodes(document, subelement, subTagNode.getAllChildren());
                    element.appendChild(subelement);
                    continue;
                }
                if (!(baseToken instanceof List)) continue;
                List sublist = (List)((Object)baseToken);
                this.createSubnodes(document, element, sublist);
            }
            if (cdata != null) {
                if (!cdata.getData().startsWith(NEW_LINE)) {
                    cdata.setData("*/\n" + cdata.getData());
                } else {
                    cdata.setData(CSS_COMMENT_END + cdata.getData());
                }
                if (!cdata.getData().endsWith(NEW_LINE)) {
                    cdata.appendData(NEW_LINE);
                }
                cdata.appendData(CSS_COMMENT_START);
                element.appendChild(document.createTextNode(CSS_COMMENT_END));
            }
        }
    }
}

