/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.acdc.common.service;

public class HeadingLevel {
    private int minimumHeadingLevel = 1;
    private int maximumHeadingLevel = 6;

    public HeadingLevel(String minimumHeadingLevel, String maximumHeadingLevel) {
        if (minimumHeadingLevel != null) {
            String minToConvert = minimumHeadingLevel.replace(" ", "");
            try {
                this.minimumHeadingLevel = Integer.parseInt(minToConvert);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maximumHeadingLevel != null) {
            String maxToConvert = maximumHeadingLevel.replace(" ", "");
            try {
                this.maximumHeadingLevel = Integer.parseInt(maxToConvert);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.minimumHeadingLevel > this.maximumHeadingLevel) {
            this.minimumHeadingLevel = 1;
            this.maximumHeadingLevel = 4;
        }
        if (this.maximumHeadingLevel > 6) {
            this.maximumHeadingLevel = 6;
        }
        if (this.minimumHeadingLevel > 6) {
            this.minimumHeadingLevel = 6;
        }
    }

    public String getRegex() {
        String regex = this.minimumHeadingLevel == 0 ? "" : (this.minimumHeadingLevel == this.maximumHeadingLevel ? "h" + this.minimumHeadingLevel : "h[" + this.minimumHeadingLevel + "-" + this.maximumHeadingLevel + "]");
        return regex;
    }
}

