/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.acdc.api;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import hu.metainf.acdc.common.data.AcdcPage;
import hu.metainf.acdc.common.view.HtmlCodeGenerator;
import hu.metainf.acdc.service.PagesService;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class AcdcMacro
implements Macro {
    private static final Logger logger = Logger.getLogger(AcdcMacro.class);
    private PageBuilderService pageBuilderService;
    private PermissionManager permissionManager;
    private PageManager pageManager;
    private SettingsManager settingsManager;

    @Autowired
    public AcdcMacro(@ComponentImport PageBuilderService pageBuilderService, @ComponentImport PermissionManager permissionManager, @ComponentImport PageManager pageManager, @ComponentImport SettingsManager settingsManager) {
        this.pageBuilderService = pageBuilderService;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
    }

    public String execute(Map<String, String> requestParams, String s, ConversionContext conversionContext) throws MacroExecutionException {
        logger.debug((Object)("conversionContext: " + conversionContext));
        logger.debug((Object)("pageManager: " + this.pageManager));
        logger.debug((Object)("settingsManager: " + this.settingsManager));
        this.pageBuilderService.assembler().resources().requireWebResource("hu.metainf.plugin.confluence.advanced-children-display-for-confluence:acnc-common-resources");
        PagesService pagesService = new PagesService(requestParams, conversionContext, this.pageManager, this.settingsManager, this.permissionManager);
        HtmlCodeGenerator htmlCodeGenerator = new HtmlCodeGenerator(requestParams);
        String outp = conversionContext.getOutputType();
        if (outp.equals("pdf")) {
            htmlCodeGenerator.setPdfOutputType();
        }
        AcdcPage pageList = pagesService.collectPages();
        return htmlCodeGenerator.acdcPageToHtml(pageList);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

