import {
    checkIfSetNameValid,
    createCompleteSetDataObject,
    createDeleteWarningWindow,
    createHistoryWindow,
    createStatusTemplateWindow,
    createTextTemplateWindow,
    deleteStatusNameFromPage,
    deleteTextNameFromPage,
    generateUUID,
    getCompleteStatusSetData,
    getCompleteTextSetData,
    getSpaceKeyContext,
    getStatusRestoreButtonData,
    getTextRestoreButtonData,
    handleNewInputsInStatusSetEditor,
    resizable,
    setStatusNameOnConfigMainPage,
    setTextNameOnConfigMainPage,
    showFlagFromRestoreResponse,
} from "./edm-config-functions";

AJS.toInit(function () {

    const getStatusHistoryHtml = function (statusHistory) {
        return Confluence.Sap.Configure.statusHistory({
            statusHistory: statusHistory,
            auiVersion: parseInt(AJS.version)
        });
    };

    const getTextHistoryHtml = function (textHistory) {
        return Confluence.Sap.Configure.textHistory({
            textHistory: textHistory,
            auiVersion: parseInt(AJS.version)
        });
    };

    const getStatusSetEditorHtml = function (dropdownSet, isReadOnlyModeActive) {
        return Confluence.Sap.Configure.Lozenge.Editor.doGet({
            dropdown_set: dropdownSet,
            isReadOnlyModeActive: isReadOnlyModeActive,
            auiVersion: parseInt(AJS.version)
        });
    };

    const getTextSetEditorHtml = function (dropdownSet, isReadOnlyModeActive) {
        return Confluence.Sap.Configure.Text.Editor.doGet({
            dropdown_set: dropdownSet,
            isReadOnlyModeActive: isReadOnlyModeActive,
            auiVersion: parseInt(AJS.version)
        });
    };

    AJS.$(document).on('click', '.edm-edit-lozenge-set-template', function () {
        const setId = this.getAttribute('data-edm-lozenge-set-template-id');
        Edm.Rest.getStatusSet(setId).done((dropdownSet) => {
            let isReadOnlyModeActive = AJS.Meta.get('access-mode') === 'READ_ONLY';
            createStatusTemplateWindow(dropdownSet, isReadOnlyModeActive, getStatusSetEditorHtml);
        });
    });
    AJS.$(document).on('click', '.edm-lozenge-show-history', function () {
        const setId = this.getAttribute('data-edm-set-id');
        Edm.Rest.getStatusHistory(setId).done((resp) => {
            createHistoryWindow(resp, getStatusHistoryHtml);
        });
    });

    AJS.$(document).on('click', '.edm-text-show-history', function () {
        let setId = this.getAttribute('data-edm-set-id');
        Edm.Rest.getTextHistory(setId).done((resp) => {
            createHistoryWindow(resp, getTextHistoryHtml);
        })
    });

    AJS.$(document).on('click', '.edm-restore-status-option', function () {
        const data = getStatusRestoreButtonData(this);
        const button = $(this);
        Edm.Rest.restoreStatusOption(data).done((resp) => {
            showFlagFromRestoreResponse(resp, button);
        });
    });

    AJS.$(document).on('click', '.edm-restore-text-option', function () {
        const data = getTextRestoreButtonData(this);
        const button = $(this);
        Edm.Rest.restoreTextOption(data).done((resp) => {
            showFlagFromRestoreResponse(resp, button);
        });
    });

    //todo Here a new rest call needs to get introduced after the set got created, that fetches the dropdowns, the response has nothing to do with the actual logic of creating a set.
    AJS.$(document).on('click', '#edm-add-status-set-button', function () {
        const newSetName = AJS.$('#edm-status-added-set-name').val();
        const valid = checkIfSetNameValid(newSetName, AJS.$('.edm-status-key-field'));
        if (valid) {
            let data = createCompleteSetDataObject(getSpaceKeyContext(), "", newSetName, []);
            Edm.Rest.createStatusSet(data).done((resp) => {
                window.location.reload(true);
            });

            //todo this logic needs to be done in a different manner. As a workaround we are reloading the config page now.

            // Edm.Rest.post(urls.addStatusSet, setData, function (resp) {
            //     replaceLozengeHtmlWithResponse(resp, getHtmlStringFromLozenges)
            // })
        }
    });

//----------------------------Status-Set-Editor-------------------------------------->>>>>>
    AJS.$(document).on('click', '.edm-delete-lozenge-set-row', function () {
        if (AJS.Meta.get('access-mode') !== 'READ_ONLY') {
            const setToDeleteId = this.getAttribute('data-edm-set-id');
            const setToDeleteName = this.getAttribute('data-edm-set-name');
            createDeleteWarningWindow(setToDeleteId, "edm-status-delete-warning-button", setToDeleteName);
        }
    });

    AJS.$(document).on('click', '#edm-status-delete-warning-button', function () {
        const id = this.getAttribute('data-edm-set-id');

        AJS.dialog2("#edm-delete-warning-config").hide();

        Edm.Rest.deleteStatusSet(id, getSpaceKeyContext()).done((resp) => {
            deleteStatusNameFromPage(id);
        });
    });

    AJS.$(document).on('change', '#t1', function () {
        const subtleCheckbox = AJS.$(this).closest('.edm-editor-status-list-element').find('.edm-option-subtle-checkbox');
        if (this.checked) {
            subtleCheckbox.attr("checked", false)
        }
    });

    AJS.$(document).on('change', '#t2', function () {
        const textWhiteCheckbox = AJS.$(this).closest('.edm-editor-status-list-element').find('.edm-checkbox-text-white');
        if (this.checked) {
            textWhiteCheckbox.attr("checked", false)
        }
    });

    const handleOptionChange = function () {
        const chosenColorFromPicker = AJS.$(this).closest('.edm-editor-status-list-element').find('.color-picker-input').val();
        const inputField = AJS.$(this).closest('.edm-editor-status-list-element').find('.edm-option-field-input');
        const subtleCheckbox = AJS.$(this).closest('.edm-editor-status-list-element').find('.edm-option-subtle-checkbox');
        const textWhiteCheckbox = AJS.$(this).closest('.edm-editor-status-list-element').find('.edm-checkbox-text-white');

        handleNewInputsInStatusSetEditor(subtleCheckbox, inputField, chosenColorFromPicker, textWhiteCheckbox);
    };
    AJS.$(document).on('change', '.color-picker-input, .edm-option-subtle-checkbox, .edm-checkbox-text-white', handleOptionChange);


    AJS.$(document).on('click', '.edm-delete-status-option', function () {
        $(this).closest('.edm-editor-status-list-element').remove();
    });

    AJS.$(document).on('click', '.edm-status-editor-add-option-button', function () {
        const listElement = AJS.$(this).closest('.add-option-container-element').find('.edm-editor-status-list-element').clone();
        listElement.prop('id', generateUUID());
        AJS.$(listElement).find('.text-white-span').remove();
        AJS.$(listElement).find('.subtle-span').remove();
        AJS.$('.edm-set-editor-list').append(listElement);
        AJS.$(listElement).find('.edm-delete-status-option').show();
        AJS.$(this).closest('.add-option-container-element').find('.edm-option-field-input').val("");
    });

    AJS.$(document).on('click', '#edm-status-editor-save-set-button', function () {
        const set = getCompleteStatusSetData();
        if (set.name.length >= 1) {
            Edm.Rest.updateStatusSet(set).done((resp) => {
                AJS.dialog2('#edm-status-dialog-config').hide();
                setStatusNameOnConfigMainPage(set.name, set.id);
            });
        }
    });

//------------------------------Text-Set-Editor------------------------------------------------------>>>

    AJS.$(document).on('click', '.edm-edit-text-set-template', function () {
        const setId = this.getAttribute('data-edm-lozenge-set-template-id');
        Edm.Rest.getTextSet(setId).done((dropdownSet) => {
            let isReadOnlyModeActive = AJS.Meta.get('access-mode') === 'READ_ONLY';
            createTextTemplateWindow(dropdownSet, isReadOnlyModeActive, getTextSetEditorHtml)
        });
    });

    AJS.$(document).on('click', '#edm-add-text-set-button', function () {
        const newSetName = AJS.$('#edm-text-added-set-name').val();
        const setNameValid = checkIfSetNameValid(newSetName, AJS.$('.edm-text-key-field'));

        if (setNameValid) {
            let setData = createCompleteSetDataObject(getSpaceKeyContext(), "", newSetName, []);
            Edm.Rest.createTextSet(setData).done((resp) => {
                window.location.reload(true);
            });

            //todo this here needs to be done in a different manner, the response now is not a lsit of the set-names.

            // replaceTextHtmlWithResponse(resp, getHtmlStringFromText)
        } else {
            Edm.Flag.newFlag("warning", `Set "${newSetName}" already exists! Please choose another name.`);
        }
    });

    AJS.$(document).on('click', '.edm-text-editor-add-option-button', function () {
        const id = generateUUID();
        const listElement = $(this).closest('.add-option-container-element').find('.edm-editor-text-list-element').clone();
        listElement.prop('id', id);
        AJS.$('.edm-text-set-editor-list').append(listElement);
        AJS.$(listElement).find('.edm-delete-text-option').show();
        AJS.$('.edm-text-field-input').each(function () {
            resizable(this, 7);
        });
        AJS.$(this).closest('.add-option-container-element').find('.edm-text-field-input').val("");
    });

    AJS.$(document).on('click', '.edm-delete-text-option', function () {
        $(this).closest('.edm-editor-text-list-element').remove();
    });

    AJS.$(document).on('click', '#edm-text-editor-save-set-button', function () {
        let set = getCompleteTextSetData();
        if (set.name.length >= 1) {
            Edm.Rest.updateTextSet(set).done((resp) => {
                AJS.dialog2('#edm-text-dialog-config').hide();
                setTextNameOnConfigMainPage(set.name, set.id);
            });
        }
    });

    AJS.$(document).on('click', '.edm-delete-text-set-row', function () {
        if (AJS.Meta.get('access-mode') !== 'READ_ONLY') {
            const setToDeleteId = this.getAttribute('data-edm-set-id');
            const setToDeleteName = this.getAttribute('data-edm-set-name');
            createDeleteWarningWindow(setToDeleteId, "edm-text-delete-warning-button", setToDeleteName);
        }
    });

    AJS.$(document).on('click', '#edm-text-delete-warning-button', function () {
        let setId = this.getAttribute('data-edm-set-id');
        AJS.dialog2("#edm-delete-warning-config").hide();
        let spaceKey = "";
        if (AJS.params.spaceKey) {
            spaceKey = AJS.params.spaceKey;
        }
        Edm.Rest.deleteTextSet(setId, spaceKey).done((resp) => {
            deleteTextNameFromPage(setId);
        });
    });
});
